/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.Declaration;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.bi.InnerBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsFilterBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsJoinBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsScoringBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public abstract class DroolsAbstractBiConstraintStream<Solution_, A, B>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerBiConstraintStream<A, B> {
    protected final DroolsAbstractBiConstraintStream<Solution_, A, B> parent;
    protected final List<DroolsAbstractBiConstraintStream<Solution_, A, B>> childStreamList = new ArrayList<DroolsAbstractBiConstraintStream<Solution_, A, B>>(2);

    public DroolsAbstractBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent) {
        super(constraintFactory);
        if (parent == null && !(this instanceof DroolsJoinBiConstraintStream)) {
            throw new IllegalArgumentException("Parent of stream (" + this + ") must not be null, or not join stream.");
        }
        this.parent = parent;
    }

    public DroolsAbstractUniConstraintStream<Solution_, A> getLeftParentStream() {
        return this.parent.getLeftParentStream();
    }

    public DroolsAbstractUniConstraintStream<Solution_, B> getRightParentStream() {
        return this.parent.getRightParentStream();
    }

    @Override
    public BiConstraintStream<A, B> filter(BiPredicate<A, B> predicate) {
        DroolsFilterBiConstraintStream stream = new DroolsFilterBiConstraintStream(this.constraintFactory, this, predicate);
        this.childStreamList.add(stream);
        return stream;
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        DroolsConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher, boolean positive) {
        DroolsConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        DroolsConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher, boolean positive) {
        DroolsConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, positive);
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public void createRuleItemBuilders(List<RuleItemBuilder<?>> ruleItemBuilderList, Global<? extends AbstractScoreHolder> scoreHolderGlobal) {
        for (DroolsAbstractBiConstraintStream<Solution_, A, B> childStream : this.childStreamList) {
            childStream.createRuleItemBuilders(ruleItemBuilderList, scoreHolderGlobal);
        }
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        if (this.parent == null) {
            DroolsJoinBiConstraintStream joinStream = (DroolsJoinBiConstraintStream)this;
            List leftParentFromStreamList = joinStream.getLeftParentStream().getFromStreamList();
            List rightParentFromStreamList = joinStream.getRightParentStream().getFromStreamList();
            return Stream.concat(leftParentFromStreamList.stream(), rightParentFromStreamList.stream()).collect(Collectors.toList());
        }
        return this.parent.getFromStreamList();
    }

    public abstract Declaration<A> getLeftVariableDeclaration();

    public abstract PatternDSL.PatternDef<A> getLeftPattern();

    public abstract Declaration<B> getRightVariableDeclaration();

    public abstract PatternDSL.PatternDef<B> getRightPattern();
}

