/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.util.Collections;
import java.util.List;
import org.drools.model.Declaration;
import org.drools.model.PatternDSL;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;

public final class DroolsFromUniConstraintStream<Solution_, A>
extends DroolsAbstractUniConstraintStream<Solution_, A> {
    private final Class<A> fromClass;
    private final Declaration<A> variableDeclaration;
    private final PatternDSL.PatternDef<A> pattern;

    public DroolsFromUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, Class<A> fromClass) {
        super(constraintFactory);
        if (fromClass == null) {
            throw new IllegalArgumentException("The fromClass (null) cannot be null.");
        }
        this.fromClass = fromClass;
        this.variableDeclaration = PatternDSL.declarationOf(fromClass);
        this.pattern = PatternDSL.pattern(this.variableDeclaration);
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return Collections.singletonList(this);
    }

    public String toString() {
        return "From(" + this.fromClass.getSimpleName() + ") with " + this.childStreamList.size() + " children";
    }

    public Class<A> getFromClass() {
        return this.fromClass;
    }

    @Override
    public Declaration<A> getVariableDeclaration() {
        return this.variableDeclaration;
    }

    @Override
    public PatternDSL.PatternDef<A> getPattern() {
        return this.pattern;
    }
}

