/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.Declaration;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block3;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsScoringUniConstraintStream<Solution_, A>
extends DroolsAbstractUniConstraintStream<Solution_, A> {
    private final DroolsAbstractUniConstraintStream<Solution_, A> parent;
    private final DroolsConstraint<Solution_> constraint;
    private final boolean noMatchWeigher;
    private final ToIntFunction<A> intMatchWeigher;
    private final ToLongFunction<A> longMatchWeigher;
    private final Function<A, BigDecimal> bigDecimalMatchWeigher;

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsConstraint<Solution_> constraint) {
        this(constraintFactory, parent, constraint, true, null, null, null);
    }

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsConstraint<Solution_> constraint, ToIntFunction<A> intMatchWeigher) {
        this(constraintFactory, parent, constraint, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsConstraint<Solution_> constraint, ToLongFunction<A> longMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsConstraint<Solution_> constraint, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsConstraint<Solution_> constraint, boolean noMatchWeigher, ToIntFunction<A> intMatchWeigher, ToLongFunction<A> longMatchWeigher, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory);
        this.parent = parent;
        this.constraint = constraint;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    @Override
    public void createRuleItemBuilders(List<RuleItemBuilder<?>> ruleItemBuilderList, Global<? extends AbstractScoreHolder> scoreHolderGlobal) {
        ConsequenceBuilder._2 consequence;
        PatternDSL.PatternDef<A> parentPattern = this.getPattern();
        Declaration<A> aVar = this.getVariableDeclaration();
        ruleItemBuilderList.add((RuleItemBuilder<?>)parentPattern);
        if (this.intMatchWeigher != null) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar).execute((Block3 & Serializable)(drools, scoreHolder, a) -> {
                RuleContext kcontext = (RuleContext)drools;
                int weightMultiplier = this.intMatchWeigher.applyAsInt(a);
                scoreHolder.impactScore(kcontext, weightMultiplier);
            });
        } else if (this.longMatchWeigher != null) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar).execute((Block3 & Serializable)(drools, scoreHolder, a) -> {
                RuleContext kcontext = (RuleContext)drools;
                long weightMultiplier = this.longMatchWeigher.applyAsLong(a);
                scoreHolder.impactScore(kcontext, weightMultiplier);
            });
        } else if (this.bigDecimalMatchWeigher != null) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar).execute((Block3 & Serializable)(drools, scoreHolder, a) -> {
                RuleContext kcontext = (RuleContext)drools;
                BigDecimal weightMultiplier = this.bigDecimalMatchWeigher.apply(a);
                scoreHolder.impactScore(kcontext, weightMultiplier);
            });
        } else if (this.noMatchWeigher) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar).execute((Block3 & Serializable)(drools, scoreHolder, a) -> {
                RuleContext kcontext = (RuleContext)drools;
                scoreHolder.impactScore(kcontext);
            });
        } else {
            throw new IllegalStateException("Impossible state: noMatchWeigher (" + this.noMatchWeigher + ").");
        }
        ruleItemBuilderList.add((RuleItemBuilder<?>)consequence);
    }

    public String toString() {
        return "Scoring()";
    }

    @Override
    public Declaration<A> getVariableDeclaration() {
        return this.parent.getVariableDeclaration();
    }

    @Override
    public PatternDSL.PatternDef<A> getPattern() {
        return this.parent.getPattern();
    }
}

