/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;

public final class GraphLayerImpl
implements GraphLayer {
    private int level;
    private final List<Vertex> vertices = new ArrayList<Vertex>();

    public GraphLayerImpl(int level) {
        this();
        this.level = level;
    }

    public GraphLayerImpl() {
    }

    public void addVertex(Vertex vertex) {
        this.vertices.add(vertex);
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void addNewVertex(String vertexId) {
        this.vertices.add(new Vertex(vertexId));
    }

    public GraphLayer clone() {
        GraphLayerImpl clone = new GraphLayerImpl(this.level);
        List<Vertex> cloneVertices = clone.getVertices();
        for (Vertex v : this.vertices) {
            cloneVertices.add(v.clone());
        }
        return clone;
    }

    public String toString() {
        return this.vertices.stream().map(Vertex::getId).collect(Collectors.joining(", ", "LAYER " + this.level + " [", "]"));
    }
}

