/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class SafeDeleteNodeProcessor {
    private final Set<String> processedConnectors = new HashSet<String>();
    private final Node<Definition<?>, Edge> candidate;
    private final Graph graph;
    private final ChildrenTraverseProcessor childrenTraverseProcessor;
    private final boolean keepChildren;

    public SafeDeleteNodeProcessor(ChildrenTraverseProcessor childrenTraverseProcessor, Graph graph, Node<Definition<?>, Edge> candidate) {
        this(childrenTraverseProcessor, graph, candidate, false);
    }

    public SafeDeleteNodeProcessor(ChildrenTraverseProcessor childrenTraverseProcessor, Graph graph, Node<Definition<?>, Edge> candidate, boolean keepChildren) {
        this.childrenTraverseProcessor = childrenTraverseProcessor;
        this.graph = graph;
        this.candidate = candidate;
        this.keepChildren = keepChildren;
    }

    public void run(Callback callback) {
        Deque<Node<View, Edge>> nodes = this.createNodesDequeue();
        this.processedConnectors.clear();
        if (!this.keepChildren) {
            this.deleteChildren(callback, nodes);
        }
        this.processNode(this.candidate, callback, true);
    }

    Deque<Node<View, Edge>> createNodesDequeue() {
        return new ArrayDeque<Node<View, Edge>>();
    }

    protected void deleteChildren(Callback callback, final Deque<Node<View, Edge>> nodes) {
        this.childrenTraverseProcessor.setRootUUID(this.candidate.getUUID()).traverse((Object)this.graph, (Object)new AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>(){

            @Override
            public void startNodeTraversal(Node<View, Edge> node) {
                super.startNodeTraversal(node);
                if (GraphUtils.isDockedNode(node)) {
                    return;
                }
                nodes.add(node);
            }

            @Override
            public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> node) {
                super.startNodeTraversal(parents, node);
                if (GraphUtils.isDockedNode(node)) {
                    return true;
                }
                nodes.add(node);
                return true;
            }
        });
        nodes.descendingIterator().forEachRemaining(node -> this.processNode((Node<?, Edge>)node, callback, false));
    }

    void processNode(Node<?, Edge> node, Callback callback, boolean isTheCandidate) {
        GraphUtils.getDockedNodes(node).forEach(docked -> this.processNode((Node<?, Edge>)docked, callback, false));
        GraphUtils.getDockParent(node).ifPresent(parent -> callback.removeDock((Node<?, Edge>)parent, node));
        Stream.concat(node.getOutEdges().stream(), node.getInEdges().stream()).filter(e -> e.getContent() instanceof View).forEach(e -> this.deleteConnector(callback, (Edge<? extends View<?>, Node>)e, isTheCandidate));
        node.getInEdges().stream().filter(e -> e.getContent() instanceof Child).forEach(e -> callback.removeChild((Element<?>)e.getSourceNode(), node));
        if (isTheCandidate) {
            callback.deleteCandidateNode(node);
        } else {
            callback.deleteNode(node);
        }
    }

    private void deleteConnector(Callback callback, Edge<? extends View<?>, Node> edge, boolean isTheCandidate) {
        if (!this.processedConnectors.contains(edge.getUUID())) {
            if (isTheCandidate) {
                callback.deleteCandidateConnector(edge);
            } else {
                callback.deleteConnector(edge);
            }
            this.processedConnectors.add(edge.getUUID());
        }
    }

    public static interface Callback {
        public void deleteCandidateConnector(Edge<? extends View<?>, Node> var1);

        public boolean deleteConnector(Edge<? extends View<?>, Node> var1);

        public void removeChild(Element<?> var1, Node<?, Edge> var2);

        public void removeDock(Node<?, Edge> var1, Node<?, Edge> var2);

        public void deleteCandidateNode(Node<?, Edge> var1);

        public boolean deleteNode(Node<?, Edge> var1);

        default public void moveChildToCanvasRoot(Element<?> canvas, Node<?, Edge> node) {
        }
    }
}

