/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.search.Query;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.MultipleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

public abstract class AbstractFindQuery {
    protected Query buildFromMultipleTerms(Set<ValueIndexTerm> terms) {
        MultipleTermQueryBuilder builder = new MultipleTermQueryBuilder();
        for (ValueIndexTerm term : terms) {
            builder.addTerm(term);
        }
        return builder.build();
    }

    protected Query buildFromSingleTerm(Set<ValueIndexTerm> terms) {
        return this.buildFromSingleTerm(terms.iterator().next());
    }

    protected Query buildFromSingleTerm(ValueIndexTerm term) {
        SingleTermQueryBuilder builder = new SingleTermQueryBuilder(term);
        return builder.build();
    }

    protected void checkNotNullAndNotEmpty(Set<ValueIndexTerm> terms) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        if (terms.isEmpty()) {
            throw new IllegalArgumentException("At least 1 term must be submitted when querying referenced resources");
        }
    }

    @SafeVarargs
    protected final void checkInvalidAndRequiredTerms(Set<ValueIndexTerm> queryTerms, String queryName, String[] requiredTermNames, Predicate<ValueIndexTerm> ... validTermTests) {
        int i;
        int[] found = new int[validTermTests.length];
        block0: for (ValueIndexTerm term : queryTerms) {
            for (int i2 = 0; i2 < validTermTests.length; ++i2) {
                if (!validTermTests[i2].test(term)) continue;
                int n = i2;
                found[n] = found[n] + 1;
                continue block0;
            }
            throw new IllegalArgumentException("Index term '" + term.getTerm() + "' can not be used with the " + queryName);
        }
        if (queryTerms.size() > validTermTests.length) {
            throw new IllegalArgumentException("More terms submitted [" + queryTerms.size() + "] than can be accepted [" + validTermTests.length + "]");
        }
        for (i = 0; i < found.length; ++i) {
            if (found[i] <= 1) continue;
            throw new IllegalArgumentException("Duplicate terms are not accepted by the " + queryName);
        }
        for (i = 0; i < requiredTermNames.length; ++i) {
            if (requiredTermNames[i] == null || found[i] != 0) continue;
            throw new IllegalArgumentException("Expected '" + requiredTermNames[i] + "' term was not found.");
        }
    }

    protected void checkTermsSize(int expected, Set<ValueIndexTerm> terms) {
        if (terms.size() > expected) {
            throw new IllegalArgumentException("Expected " + expected + " terms, not " + terms.size() + " terms.");
        }
    }
}

