/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service.htmleditor;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.htmleditor.HtmlEditorService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;

public class HtmlEditorServiceImpl
implements HtmlEditorService {
    private VFSService vfsServices;
    private DeleteService deleteService;
    private RenameService renameService;
    private CopyService copyService;
    private SaveAndRenameServiceImpl<String, DefaultMetadata> saveAndRenameService;

    @Inject
    public HtmlEditorServiceImpl(VFSService vfsServices, DeleteService deleteService, RenameService renameService, CopyService copyService, SaveAndRenameServiceImpl<String, DefaultMetadata> saveAndRenameService) {
        this.vfsServices = vfsServices;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.copyService = copyService;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename<String, DefaultMetadata>)this);
    }

    public void delete(Path path, String comment) {
        this.deleteService.delete(path, comment);
    }

    public Path rename(Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public Path save(Path path, String content, DefaultMetadata _metadata, String _comment) {
        return this.vfsServices.write(path, content);
    }

    public Path copy(Path path, String newName, String comment) {
        return this.copyService.copy(path, newName, comment);
    }

    public Path copy(Path path, String newName, Path targetDirectory, String comment) {
        return this.copyService.copy(path, newName, targetDirectory, comment);
    }

    public String load(Path path) {
        return this.vfsServices.readAllString(path);
    }

    public Path saveAndRename(Path path, String newFileName, DefaultMetadata metadata, String content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, metadata, content, comment);
    }
}

