/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service;

import java.util.ArrayList;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.experimental.service.ExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.backend.BackendExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.backend.ExperimentalFeaturesSession;
import org.uberfire.experimental.service.backend.impl.ExperimentalFeaturesSessionImpl;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.editor.FeaturesEditorService;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeaturesRegistryImpl;
import org.uberfire.experimental.service.storage.ExperimentalFeaturesStorage;

@Service
@ApplicationScoped
public class BackendExperimentalFeaturesRegistryServiceImpl
implements ExperimentalFeaturesRegistryService,
BackendExperimentalFeaturesRegistryService,
FeaturesEditorService {
    public static final String EXPERIMENTAL_FEATURES_PROPERTY_NAME = "appformer.experimental.features";
    private final ExperimentalFeatureDefRegistry defRegistry;
    private ExperimentalFeaturesStorage globalStorage;
    private ExperimentalFeaturesStorage userStorage;

    @Inject
    public BackendExperimentalFeaturesRegistryServiceImpl(ExperimentalFeatureDefRegistry defRegistry, @Named(value="global") ExperimentalFeaturesStorage globalStorage, @Named(value="user") ExperimentalFeaturesStorage userStorage) {
        this.defRegistry = defRegistry;
        this.globalStorage = globalStorage;
        this.userStorage = userStorage;
    }

    public ExperimentalFeaturesRegistryImpl getFeaturesRegistry() {
        return this.loadRegistry();
    }

    public Boolean isExperimentalEnabled() {
        return Boolean.parseBoolean(System.getProperty(EXPERIMENTAL_FEATURES_PROPERTY_NAME, "false"));
    }

    public boolean isFeatureEnabled(String featureId) {
        ExperimentalFeaturesRegistryImpl registry = this.getFeaturesRegistry();
        if (!registry.getFeature(featureId).isPresent()) {
            return true;
        }
        return this.isExperimentalEnabled() != false && this.getFeaturesRegistry().isFeatureEnabled(featureId);
    }

    public void save(EditableExperimentalFeature editableFeature) {
        if (!this.isExperimentalEnabled().booleanValue()) {
            throw new IllegalStateException("Impossible edit feature '" + editableFeature.getFeatureId() + "': Experimental Framework is disabled");
        }
        Optional<ExperimentalFeatureDefinition> optional = Optional.ofNullable(this.defRegistry.getFeatureById(editableFeature.getFeatureId()));
        if (optional.isPresent()) {
            ExperimentalFeatureDefinition definition = optional.get();
            ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl(editableFeature.getFeatureId(), editableFeature.isEnabled());
            if (definition.isGlobal()) {
                this.globalStorage.store(feature);
            } else {
                this.userStorage.store(feature);
            }
        } else {
            throw new IllegalArgumentException("Cannot find ExperimentalFeature '" + editableFeature.getFeatureId() + "'");
        }
    }

    private ExperimentalFeaturesRegistryImpl loadRegistry() {
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>();
        features.addAll(this.userStorage.getFeatures());
        features.addAll(this.globalStorage.getFeatures());
        return new ExperimentalFeaturesRegistryImpl(features);
    }

    public ExperimentalFeaturesSession getExperimentalFeaturesSession() {
        return new ExperimentalFeaturesSessionImpl(this.isExperimentalEnabled().booleanValue(), this.getFeaturesRegistry());
    }
}

