/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.screens.workbench.backend;

import java.util.List;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;

public abstract class BaseAppSetup {
    protected static final Logger logger = LoggerFactory.getLogger(BaseAppSetup.class);
    protected static final String GLOBAL_SETTINGS = "settings";
    protected static final String GIT_SCHEME = "git";
    protected IOService ioService;
    protected RepositoryService repositoryService;
    protected OrganizationalUnitService organizationalUnitService;
    protected KieModuleService moduleService;
    protected ConfigurationService configurationService;
    protected ConfigurationFactory configurationFactory;

    protected BaseAppSetup() {
    }

    public BaseAppSetup(IOService ioService, RepositoryService repositoryService, OrganizationalUnitService organizationalUnitService, KieModuleService moduleService, ConfigurationService configurationService, ConfigurationFactory configurationFactory) {
        this.ioService = ioService;
        this.repositoryService = repositoryService;
        this.organizationalUnitService = organizationalUnitService;
        this.moduleService = moduleService;
        this.configurationService = configurationService;
        this.configurationFactory = configurationFactory;
    }

    protected void setupConfigurationGroup(ConfigType configType, String configGroupName, ConfigGroup configGroup, ConfigItem ... configItemsToSetManually) {
        List existentConfigGroups = this.configurationService.getConfiguration(configType);
        boolean settingsDefined = false;
        for (ConfigGroup existentConfigGroup : existentConfigGroups) {
            if (!configGroupName.equals(existentConfigGroup.getName())) continue;
            settingsDefined = true;
            if (configItemsToSetManually == null) break;
            for (ConfigItem configItem : configItemsToSetManually) {
                ConfigItem existentConfigItem = existentConfigGroup.getConfigItem(configItem.getName());
                if (existentConfigItem == null) {
                    existentConfigGroup.addConfigItem(configItem);
                    this.configurationService.updateConfiguration(existentConfigGroup);
                    continue;
                }
                if (existentConfigItem.getValue().equals(configItem.getValue())) continue;
                existentConfigItem.setValue(configItem.getValue());
                this.configurationService.updateConfiguration(existentConfigGroup);
            }
        }
        if (!settingsDefined) {
            this.configurationService.addConfiguration(configGroup);
        }
    }
}

