/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;

public class GenericServiceTaskPropertyWriter
extends MultipleInstanceActivityPropertyWriter {
    private final ServiceTask task;
    private final Interface iface;
    private Message message;

    public GenericServiceTaskPropertyWriter(ServiceTask task, VariableScope variableScope) {
        super((Activity)task, variableScope);
        this.task = task;
        this.iface = Factories.bpmn2.createInterface();
    }

    public void setServiceImplementation(String serviceImplementation) {
        if (!serviceImplementation.equals("Java")) {
            serviceImplementation = "##WebService";
        }
        this.task.setImplementation(serviceImplementation);
        CustomAttribute.serviceImplementation.of((BaseElement)this.task).set(serviceImplementation);
    }

    public void setServiceOperation(String serviceOperation) {
        CustomAttribute.serviceOperation.of((BaseElement)this.task).set(serviceOperation);
        Operation operation = Factories.bpmn2.createOperation();
        operation.setId(this.task.getId() + "_ServiceOperation");
        operation.setName(serviceOperation);
        operation.setImplementationRef(serviceOperation);
        this.iface.getOperations().add(operation);
        this.task.setOperationRef(operation);
        this.addInterfaceDefinition(this.iface);
        operation.setInMessageRef(this.message);
    }

    public void setServiceInterface(String serviceInterface) {
        this.message = Factories.bpmn2.createMessage();
        this.message.setId(this.task.getId() + "_InMessage");
        ItemDefinition itemDefinition = Factories.bpmn2.createItemDefinition();
        itemDefinition.setId(this.task.getId() + "_InMessageType");
        this.addItemDefinition(itemDefinition);
        this.message.setItemRef(itemDefinition);
        this.addRootElement((RootElement)this.message);
        CustomAttribute.serviceInterface.of((BaseElement)this.task).set(serviceInterface);
        this.iface.setImplementationRef(serviceInterface);
        this.iface.setName(serviceInterface);
        this.iface.setId(this.task.getId() + "_ServiceInterface");
    }

    public void setAdHocAutostart(boolean autoStart) {
        CustomElement.autoStart.of((BaseElement)this.task).set(autoStart);
    }

    public void setAsync(boolean async) {
        CustomElement.async.of((BaseElement)this.task).set(async);
    }

    public void setSLADueDate(String slaDueDate) {
        CustomElement.slaDueDate.of((BaseElement)this.task).set(slaDueDate);
    }

    public void setOnEntryAction(OnEntryAction onEntryAction) {
        Scripts.setOnEntryAction((FlowElement)this.task, onEntryAction);
    }

    public void setOnExitAction(OnExitAction onExitAction) {
        Scripts.setOnExitAction((FlowElement)this.task, onExitAction);
    }
}

