/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.tasks;

import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.UserTask;
import org.kie.workbench.common.stunner.bpmn.backend.converters.NodeMatch;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BusinessRuleTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.GenericServiceTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ScriptTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ServiceTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.UserTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BaseTask;
import org.kie.workbench.common.stunner.bpmn.definition.BaseUserTask;
import org.kie.workbench.common.stunner.bpmn.definition.GenericServiceTask;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.TaskGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseUserTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BusinessRuleTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.RuleLanguage;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTaskExecutionSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class TaskConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public TaskConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public PropertyWriter toFlowElement(Node<View<BaseTask>, ?> node) {
        return NodeMatch.fromNode(BaseTask.class, PropertyWriter.class).when(NoneTask.class, this::noneTask).when(ScriptTask.class, this::scriptTask).when(org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask.class, this::businessRuleTask).when(BaseUserTask.class, this::userTask).when(ServiceTask.class, this::serviceTask).when(GenericServiceTask.class, this::genericServiceTask).apply(node).value();
    }

    private PropertyWriter genericServiceTask(Node<View<GenericServiceTask>, ?> n) {
        org.eclipse.bpmn2.ServiceTask task = Factories.bpmn2.createServiceTask();
        task.setId(n.getUUID());
        GenericServiceTask definition = (GenericServiceTask)((View)n.getContent()).getDefinition();
        GenericServiceTaskPropertyWriter p = this.propertyWriterFactory.of(task);
        TaskGeneralSet general = definition.getGeneral();
        GenericServiceTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAbsoluteBounds(n);
        p.setSimulationSet(definition.getSimulationSet());
        p.setServiceInterface(executionSet.getGenericServiceTaskInfo().getValue().getServiceInterface());
        p.setServiceImplementation(executionSet.getGenericServiceTaskInfo().getValue().getServiceImplementation());
        p.setServiceOperation(executionSet.getGenericServiceTaskInfo().getValue().getServiceOperation());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setAdHocAutostart(executionSet.getAdHocAutostart().getValue());
        if (Boolean.TRUE.equals(executionSet.getIsMultipleInstance().getValue())) {
            p.setIsSequential(executionSet.getMultipleInstanceExecutionMode().isSequential());
            p.setCollectionInput(executionSet.getMultipleInstanceCollectionInput().getValue());
            p.setInput(executionSet.getMultipleInstanceDataInput().getValue());
            p.setCollectionOutput(executionSet.getMultipleInstanceCollectionOutput().getValue());
            p.setOutput(executionSet.getMultipleInstanceDataOutput().getValue());
            p.setCompletionCondition(executionSet.getMultipleInstanceCompletionCondition().getValue());
        }
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setSLADueDate(executionSet.getSlaDueDate().getValue());
        p.setAssignmentsInfo(executionSet.getAssignmentsinfo());
        return p;
    }

    private PropertyWriter serviceTask(Node<View<ServiceTask>, ?> n) {
        Task task = Factories.bpmn2.createTask();
        task.setId(n.getUUID());
        ServiceTask definition = (ServiceTask)((View)n.getContent()).getDefinition();
        ServiceTaskPropertyWriter p = this.propertyWriterFactory.of(task);
        p.setServiceTaskName(definition.getName());
        TaskGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        ServiceTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setTaskName(executionSet.getTaskName().getValue());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setAdHocAutostart(executionSet.getAdHocAutostart().getValue());
        p.setSlaDueDate(executionSet.getSlaDueDate().getValue());
        p.setSimulationSet(definition.getSimulationSet());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter userTask(Node<View<BaseUserTask>, ?> n) {
        UserTask task = Factories.bpmn2.createUserTask();
        task.setId(n.getUUID());
        BaseUserTask definition = (BaseUserTask)((View)n.getContent()).getDefinition();
        UserTaskPropertyWriter p = this.propertyWriterFactory.of(task);
        TaskGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setSimulationSet(definition.getSimulationSet());
        BaseUserTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setTaskName(executionSet.getTaskName().getValue());
        p.setActors(executionSet.getActors());
        p.setAssignmentsInfo(executionSet.getAssignmentsinfo());
        p.setReassignments(executionSet.getReassignmentsInfo());
        p.setNotifications(executionSet.getNotificationsInfo());
        p.setSkippable(executionSet.getSkippable().getValue());
        p.setGroupId(executionSet.getGroupid().getValue());
        p.setSubject(executionSet.getSubject().getValue());
        p.setDescription(executionSet.getDescription().getValue());
        p.setPriority(executionSet.getPriority().getValue());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setCreatedBy(executionSet.getCreatedBy().getValue());
        p.setAdHocAutostart(executionSet.getAdHocAutostart().getValue());
        if (Boolean.TRUE.equals(executionSet.getIsMultipleInstance().getValue())) {
            p.setIsSequential(executionSet.getMultipleInstanceExecutionMode().isSequential());
            p.setCollectionInput(executionSet.getMultipleInstanceCollectionInput().getValue());
            p.setInput(executionSet.getMultipleInstanceDataInput().getValue());
            p.setCollectionOutput(executionSet.getMultipleInstanceCollectionOutput().getValue());
            p.setOutput(executionSet.getMultipleInstanceDataOutput().getValue());
            p.setCompletionCondition(executionSet.getMultipleInstanceCompletionCondition().getValue());
        }
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setContent(executionSet.getContent().getValue());
        p.setSLADueDate(executionSet.getSlaDueDate().getValue());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter businessRuleTask(Node<View<org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask>, ?> n) {
        BusinessRuleTask task = Factories.bpmn2.createBusinessRuleTask();
        task.setId(n.getUUID());
        org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask definition = (org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask)((View)n.getContent()).getDefinition();
        BusinessRuleTaskPropertyWriter p = this.propertyWriterFactory.of(task);
        TaskGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        BusinessRuleTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setAdHocAutostart(executionSet.getAdHocAutostart().getValue());
        p.setSlaDueDate(executionSet.getSlaDueDate().getValue());
        RuleLanguage ruleLanguage = executionSet.getRuleLanguage();
        p.setImplementation(ruleLanguage);
        if (ruleLanguage.getValue().equals("http://www.jboss.org/drools/rule")) {
            p.setRuleFlowGroup(executionSet.getRuleFlowGroup());
        } else if (ruleLanguage.getValue().equals("http://www.jboss.org/drools/dmn")) {
            p.setNamespace(executionSet.getNamespace());
            p.setDecisionName(executionSet.getDecisionName());
            p.setDmnModelName(executionSet.getDmnModelName());
        }
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        p.setSimulationSet(definition.getSimulationSet());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter scriptTask(Node<View<ScriptTask>, ?> n) {
        org.eclipse.bpmn2.ScriptTask task = Factories.bpmn2.createScriptTask();
        task.setId(n.getUUID());
        ScriptTask definition = (ScriptTask)((View)n.getContent()).getDefinition();
        ScriptTaskPropertyWriter p = this.propertyWriterFactory.of(task);
        TaskGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        ScriptTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setScript(executionSet.getScript().getValue());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setAdHocAutostart(executionSet.getAdHocAutostart().getValue());
        p.setSimulationSet(definition.getSimulationSet());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter noneTask(Node<View<NoneTask>, ?> n) {
        Task task = Factories.bpmn2.createTask();
        task.setId(n.getUUID());
        NoneTask definition = (NoneTask)((View)n.getContent()).getDefinition();
        ServiceTaskPropertyWriter p = this.propertyWriterFactory.of(task);
        TaskGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAbsoluteBounds(n);
        p.setSimulationSet(definition.getSimulationSet());
        return p;
    }
}

