/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.impl.BoundaryEventImpl;
import org.eclipse.bpmn2.impl.EventDefinitionImpl;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.AbstractConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CatchEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventDefinitionReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.CancelActivity;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.CancellingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettings;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;

public class IntermediateCatchEventConverter
extends AbstractConverter
implements NodeConverter<IntermediateCatchEvent> {
    private final TypedFactoryManager factoryManager;
    private final PropertyReaderFactory propertyReaderFactory;

    public IntermediateCatchEventConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory, MarshallingRequest.Mode mode) {
        super(mode);
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(IntermediateCatchEvent event) {
        CatchEventPropertyReader p = this.propertyReaderFactory.of((CatchEvent)event);
        List<EventDefinition> eventDefinitions = p.getEventDefinitions();
        switch (eventDefinitions.size()) {
            case 0: {
                throw new UnsupportedOperationException("An intermediate catch event should contain exactly one definition");
            }
            case 1: {
                return Match.of(EventDefinition.class, Result.class).when(TimerEventDefinition.class, e -> this.timerEvent((CatchEvent)event, (TimerEventDefinition)e)).when(SignalEventDefinition.class, e -> this.signalEvent((CatchEvent)event, (SignalEventDefinition)e)).when(MessageEventDefinition.class, e -> this.messageEvent((CatchEvent)event, (MessageEventDefinition)e)).when(ErrorEventDefinition.class, e -> this.errorEvent((CatchEvent)event, (ErrorEventDefinition)e)).when(ConditionalEventDefinition.class, e -> this.conditionalEvent((CatchEvent)event, (ConditionalEventDefinition)e)).when(EscalationEventDefinition.class, e -> this.escalationEvent((CatchEvent)event, (EscalationEventDefinition)e)).when(CompensateEventDefinition.class, e -> this.compensationEvent((CatchEvent)event, (CompensateEventDefinition)e)).defaultValue(Result.ignored("Ignored IntermediateCatchEvent", this.getNotFoundMessage((BaseElement)event))).mode(this.getMode()).apply(eventDefinitions.get(0)).value();
            }
        }
        throw new UnsupportedOperationException("Multiple definitions not supported for intermediate catch event");
    }

    public Result<BpmnNode> convertBoundaryEvent(BoundaryEvent event) {
        CatchEventPropertyReader p = this.propertyReaderFactory.of((CatchEvent)event);
        List<EventDefinition> eventDefinitions = p.getEventDefinitions();
        switch (eventDefinitions.size()) {
            case 0: {
                throw new UnsupportedOperationException("A boundary event should contain exactly one definition");
            }
            case 1: {
                Result result = Match.of(EventDefinition.class, Result.class).when(SignalEventDefinition.class, e -> this.signalEvent((CatchEvent)event, (SignalEventDefinition)e)).when(TimerEventDefinition.class, e -> this.timerEvent((CatchEvent)event, (TimerEventDefinition)e)).when(MessageEventDefinition.class, e -> this.messageEvent((CatchEvent)event, (MessageEventDefinition)e)).when(ErrorEventDefinition.class, e -> this.errorEvent((CatchEvent)event, (ErrorEventDefinition)e)).when(ConditionalEventDefinition.class, e -> this.conditionalEvent((CatchEvent)event, (ConditionalEventDefinition)e)).when(EscalationEventDefinition.class, e -> this.escalationEvent((CatchEvent)event, (EscalationEventDefinition)e)).when(CompensateEventDefinition.class, e -> this.compensationEvent((CatchEvent)event, (CompensateEventDefinition)e)).ignore(BoundaryEventImpl.class).ignore(EventDefinitionImpl.class).defaultValue(Result.ignored("BoundaryEvent ignored", this.getNotFoundMessage((BaseElement)event))).mode(this.getMode()).apply(eventDefinitions.get(0)).value();
                return Optional.of(result).map(Result::value).filter(Objects::nonNull).map(BpmnNode.class::cast).map(BpmnNode::docked).map(node -> Result.success(node, new MarshallingMessage[0])).orElse(result);
            }
        }
        throw new UnsupportedOperationException("Multiple definitions not supported for boundary event");
    }

    private Result<BpmnNode> errorEvent(CatchEvent event, ErrorEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateErrorEventCatching.class);
        IntermediateErrorEventCatching definition = (IntermediateErrorEventCatching)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        definition.setExecutionSet(new CancellingErrorEventExecutionSet(new CancelActivity(Boolean.valueOf(p.isCancelActivity())), new SLADueDate(p.getSlaDueDate()), new ErrorRef(EventDefinitionReader.errorRefOf(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> signalEvent(CatchEvent event, SignalEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateSignalEventCatching.class);
        IntermediateSignalEventCatching definition = (IntermediateSignalEventCatching)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        definition.setExecutionSet(new CancellingSignalEventExecutionSet(new CancelActivity(Boolean.valueOf(p.isCancelActivity())), new SLADueDate(p.getSlaDueDate()), new SignalRef(p.getSignalRef())));
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> timerEvent(CatchEvent event, TimerEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateTimerEvent.class);
        IntermediateTimerEvent definition = (IntermediateTimerEvent)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setExecutionSet(new CancellingTimerEventExecutionSet(new CancelActivity(Boolean.valueOf(p.isCancelActivity())), new SLADueDate(p.getSlaDueDate()), new TimerSettings(CatchEventPropertyReader.getTimerSettings(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> messageEvent(CatchEvent event, MessageEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateMessageEventCatching.class);
        IntermediateMessageEventCatching definition = (IntermediateMessageEventCatching)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        definition.setExecutionSet(new CancellingMessageEventExecutionSet(new CancelActivity(Boolean.valueOf(p.isCancelActivity())), new SLADueDate(p.getSlaDueDate()), new MessageRef(EventDefinitionReader.messageRefOf(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> conditionalEvent(CatchEvent event, ConditionalEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateConditionalEvent.class);
        IntermediateConditionalEvent definition = (IntermediateConditionalEvent)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setExecutionSet(new CancellingConditionalEventExecutionSet(new CancelActivity(Boolean.valueOf(p.isCancelActivity())), new SLADueDate(p.getSlaDueDate()), CatchEventPropertyReader.getConditionExpression(e)));
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> escalationEvent(CatchEvent event, EscalationEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateEscalationEvent.class);
        IntermediateEscalationEvent definition = (IntermediateEscalationEvent)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setDataIOSet(new DataIOSet(p.getAssignmentsInfo()));
        definition.setExecutionSet(new CancellingEscalationEventExecutionSet(new CancelActivity(Boolean.valueOf(p.isCancelActivity())), new SLADueDate(p.getSlaDueDate()), new EscalationRef(EventDefinitionReader.escalationRefOf(e))));
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> compensationEvent(CatchEvent event, CompensateEventDefinition e) {
        String nodeId = event.getId();
        Node node = this.factoryManager.newNode(nodeId, IntermediateCompensationEvent.class);
        IntermediateCompensationEvent definition = (IntermediateCompensationEvent)((View)node.getContent()).getDefinition();
        CatchEventPropertyReader p = this.propertyReaderFactory.of(event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setFontSet(p.getFontSet());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        CancelActivity cancelActivity = new CancelActivity(Boolean.valueOf(false));
        SLADueDate slaDueDate = new SLADueDate(p.getSlaDueDate());
        BaseCancellingEventExecutionSet executionSet = new BaseCancellingEventExecutionSet(cancelActivity, slaDueDate);
        definition.setExecutionSet(executionSet);
        ((View)node.getContent()).setBounds(p.getBounds());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }
}

