/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationList;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.DeclarationList;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.InputAssignmentReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.OutputAssignmentReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;

public class AssignmentsInfos {
    private static Set<String> RESERVED_DECLARATIONS = new HashSet<String>(Arrays.asList("TaskName"));
    private static Set<String> RESERVED_ASSIGNMENTS = new HashSet<String>(Arrays.asList("GroupId", "Skippable", "Comment", "Description", "Priority", "Content", "TaskName", "Locale", "CreatedBy", "NotCompletedReassign", "NotStartedReassign", "NotCompletedNotify", "NotStartedNotify"));

    public static AssignmentsInfo of(List<DataInput> datainput, List<DataInputAssociation> inputAssociations, List<DataOutput> dataoutput, List<DataOutputAssociation> outputAssociations, boolean alternativeEncoding) {
        ParsedAssignmentsInfo parsedAssignmentsInfo = AssignmentsInfos.parsed(datainput, inputAssociations, dataoutput, outputAssociations, alternativeEncoding);
        return new AssignmentsInfo(parsedAssignmentsInfo.toString());
    }

    public static ParsedAssignmentsInfo parsed(List<DataInput> datainput, List<DataInputAssociation> inputAssociations, List<DataOutput> dataoutput, List<DataOutputAssociation> outputAssociations, boolean alternativeEncoding) {
        DeclarationList inputs = AssignmentsInfos.dataInputDeclarations(datainput);
        DeclarationList outputs = AssignmentsInfos.dataOutputDeclarations(dataoutput);
        AssociationList associations = new AssociationList(AssignmentsInfos.inAssociationDeclarations(inputAssociations), AssignmentsInfos.outAssociationDeclarations(outputAssociations));
        return new ParsedAssignmentsInfo(inputs, outputs, associations, alternativeEncoding);
    }

    public static boolean isReservedDeclaration(DataInput o) {
        return RESERVED_DECLARATIONS.contains(o.getName());
    }

    public static boolean isReservedIdentifier(String targetName) {
        return RESERVED_ASSIGNMENTS.contains(targetName);
    }

    private static DeclarationList dataInputDeclarations(List<DataInput> dataInputs) {
        return new DeclarationList(dataInputs.stream().filter(o -> !AssignmentsInfos.isReservedDeclaration(o)).map(in -> new VariableDeclaration(in.getName(), CustomAttribute.dtype.of((BaseElement)in).get())).collect(Collectors.toList()));
    }

    private static DeclarationList dataOutputDeclarations(List<DataOutput> dataOutputs) {
        return new DeclarationList(dataOutputs.stream().map(out -> new VariableDeclaration(out.getName(), CustomAttribute.dtype.of((BaseElement)out).get())).collect(Collectors.toList()));
    }

    private static List<AssociationDeclaration> inAssociationDeclarations(List<DataInputAssociation> inputAssociations) {
        return inputAssociations.stream().map(InputAssignmentReader::fromAssociation).filter(Objects::nonNull).map(InputAssignmentReader::getAssociationDeclaration).collect(Collectors.toList());
    }

    private static List<AssociationDeclaration> outAssociationDeclarations(List<DataOutputAssociation> outputAssociations) {
        return outputAssociations.stream().map(OutputAssignmentReader::fromAssociation).filter(Objects::nonNull).map(OutputAssignmentReader::getAssociationDeclaration).collect(Collectors.toList());
    }
}

