/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.FunctionDef;

public class FunctionsRegistry {
    private static final String BETWEEN = "between";
    private static final String IS_NULL = "isNull";
    private static final String EQUALS_TO = "equalsTo";
    private static final String IS_EMPTY = "isEmpty";
    private static final String CONTAINS = "contains";
    private static final String STARTS_WITH = "startsWith";
    private static final String ENDS_WITH = "endsWith";
    private static final String GREATER_THAN = "greaterThan";
    private static final String GREATER_OR_EQUAL_THAN = "greaterOrEqualThan";
    private static final String LESS_THAN = "lessThan";
    private static final String LESS_OR_EQUAL_THAN = "lessOrEqualThan";
    private static final String IS_TRUE = "isTrue";
    private static final String IS_FALSE = "isFalse";
    private static FunctionsRegistry instance = new FunctionsRegistry();
    private List<FunctionDef> registry = new ArrayList<FunctionDef>();

    private FunctionsRegistry() {
        this.initRegistry();
    }

    public static FunctionsRegistry getInstance() {
        if (instance == null) {
            instance = new FunctionsRegistry();
        }
        return instance;
    }

    public List<FunctionDef> getFunctions(String functionName) {
        return this.registry.stream().filter(functionDef -> functionDef.getName().equals(functionName)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<FunctionDef> getFunctions() {
        return Collections.unmodifiableList(this.registry);
    }

    private void initRegistry() {
        FunctionDef isNull = FunctionDef.FunctionDefBuilder.newFunction((String)IS_NULL).withParam("param1", Object.class.getName()).build();
        this.registry.add(isNull);
        FunctionDef equalsTo = FunctionDef.FunctionDefBuilder.newFunction((String)EQUALS_TO).withParam("param1", String.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(equalsTo);
        FunctionDef isEmpty = FunctionDef.FunctionDefBuilder.newFunction((String)IS_EMPTY).withParam("param1", String.class.getName()).build();
        this.registry.add(isEmpty);
        FunctionDef contains = FunctionDef.FunctionDefBuilder.newFunction((String)CONTAINS).withParam("param1", String.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(contains);
        FunctionDef startsWith = FunctionDef.FunctionDefBuilder.newFunction((String)STARTS_WITH).withParam("param1", String.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(startsWith);
        FunctionDef endsWith = FunctionDef.FunctionDefBuilder.newFunction((String)ENDS_WITH).withParam("param1", String.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(endsWith);
        FunctionDef equalsToNumeric = FunctionDef.FunctionDefBuilder.newFunction((String)EQUALS_TO).withParam("param1", Number.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(equalsToNumeric);
        FunctionDef greaterThan = FunctionDef.FunctionDefBuilder.newFunction((String)GREATER_THAN).withParam("param1", Number.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(greaterThan);
        FunctionDef greaterOrEqualThan = FunctionDef.FunctionDefBuilder.newFunction((String)GREATER_OR_EQUAL_THAN).withParam("param1", Number.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(greaterOrEqualThan);
        FunctionDef lessThan = FunctionDef.FunctionDefBuilder.newFunction((String)LESS_THAN).withParam("param1", Number.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(lessThan);
        FunctionDef lessOrEqualThan = FunctionDef.FunctionDefBuilder.newFunction((String)LESS_OR_EQUAL_THAN).withParam("param1", Number.class.getName()).withParam("param2", String.class.getName()).build();
        this.registry.add(lessOrEqualThan);
        FunctionDef between = FunctionDef.FunctionDefBuilder.newFunction((String)BETWEEN).withParam("param1", Number.class.getName()).withParam("param2", String.class.getName()).withParam("param3", String.class.getName()).build();
        this.registry.add(between);
        FunctionDef isTrue = FunctionDef.FunctionDefBuilder.newFunction((String)IS_TRUE).withParam("param1", Boolean.class.getName()).build();
        this.registry.add(isTrue);
        FunctionDef isFalse = FunctionDef.FunctionDefBuilder.newFunction((String)IS_FALSE).withParam("param1", Boolean.class.getName()).build();
        this.registry.add(isFalse);
    }
}

