/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionResources;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy.WorkItemDefinitionDeployService;
import org.kie.workbench.common.stunner.core.backend.service.BackendFileSystemManager;
import org.kie.workbench.common.stunner.core.diagram.Metadata;

@ApplicationScoped
public class WorkItemDefinitionDefaultDeployService
implements WorkItemDefinitionDeployService {
    static final String DEPLOY_MESSAGE = "Deployment of the default work item definitions";
    static final String ASSETS_ROOT = "/META-INF/org/kie/workbench/common/stunner/bpmn/backend/workitem/";
    static final String WID_FILE = "WorkDefinitions.wid";
    static final String EMAIL_ICON = "defaultemailicon.gif";
    static final String BR_ICON = "defaultbusinessrulesicon.png";
    static final String DECISION_ICON = "defaultdecisionicon.png";
    static final String LOG_ICON = "defaultlogicon.gif";
    static final String SERVICE_NODE_ICON = "defaultservicenodeicon.png";
    static final String MILESTONE_ICON = "defaultmilestoneicon.png";
    static final String[] ASSETS = new String[]{"WorkDefinitions.wid", "defaultemailicon.gif", "defaultbusinessrulesicon.png", "defaultdecisionicon.png", "defaultlogicon.gif", "defaultservicenodeicon.png", "defaultmilestoneicon.png"};
    private final WorkItemDefinitionResources resources;
    private final BackendFileSystemManager backendFileSystemManager;
    private final BiFunction<String, String, BackendFileSystemManager.Asset> assetBuilder;

    protected WorkItemDefinitionDefaultDeployService() {
        this(null, null);
    }

    @Inject
    public WorkItemDefinitionDefaultDeployService(WorkItemDefinitionResources resources, BackendFileSystemManager backendFileSystemManager) {
        this.resources = resources;
        this.backendFileSystemManager = backendFileSystemManager;
        this.assetBuilder = (fileName, cp) -> new BackendFileSystemManager.AssetBuilder().setFileName(fileName).fromClasspathResouce(cp).build();
    }

    WorkItemDefinitionDefaultDeployService(WorkItemDefinitionResources resources, BackendFileSystemManager backendFileSystemManager, BiFunction<String, String, BackendFileSystemManager.Asset> assetBuilder) {
        this.resources = resources;
        this.backendFileSystemManager = backendFileSystemManager;
        this.assetBuilder = assetBuilder;
    }

    @Override
    public void deploy(Metadata metadata) {
        this.backendFileSystemManager.deploy(this.resources.resolveGlobalPath(metadata), new BackendFileSystemManager.Assets((Collection)Arrays.stream(ASSETS).map(asset -> this.assetBuilder.apply((String)asset, ASSETS_ROOT + asset)).collect(Collectors.toList())), DEPLOY_MESSAGE);
    }
}

