/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.definition.property.reassignment;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.workbench.common.stunner.bpmn.forms.validation.reassignment.ValidReassignmentValue;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
@Bindable
@ValidReassignmentValue
public class ReassignmentValue {
    private String type;
    private String duration;
    private List<String> users;
    private List<String> groups;

    public ReassignmentValue() {
        this.groups = new ArrayList<String>();
        this.users = new ArrayList<String>();
    }

    public ReassignmentValue(@MapsTo(value="type") String type, @MapsTo(value="duration") String duration, @MapsTo(value="users") List<String> groups, @MapsTo(value="groups") List<String> users) {
        this.type = type;
        this.duration = duration;
        this.groups = groups;
        this.users = users;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String toCDATAFormat() {
        return "[users:" + this.users.stream().collect(Collectors.joining(",")) + "|groups:" + this.groups.stream().collect(Collectors.joining(",")) + "]@[" + this.duration + "]";
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode(this.duration), Objects.hashCode(this.groups), Objects.hashCode(this.users), Objects.hashCode(this.type)});
    }

    public boolean equals(Object o) {
        if (o instanceof ReassignmentValue) {
            ReassignmentValue other = (ReassignmentValue)o;
            return Objects.equals(this.duration, other.duration) && Objects.equals(this.type, other.type) && Objects.equals(this.groups, other.groups) && Objects.equals(this.users, other.users);
        }
        return false;
    }

    public String toString() {
        return "{\"type\":\"" + this.getType() + "\",\"period\":\"" + this.getDuration() + "\",\"users\":[" + this.getUsers().stream().map(u -> "\"" + u + "\"").collect(Collectors.joining(",")) + "],\"groups\":[" + this.getGroups().stream().map(u -> "\"" + u + "\"").collect(Collectors.joining(",")) + "]}";
    }
}

