/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.factory;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.factory.impl.AbstractGraphFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.DirectGraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
public class BPMNGraphFactoryImpl
extends AbstractGraphFactory
implements BPMNGraphFactory {
    public static final String START_EVENT_ID = BindableAdapterUtils.getDefinitionId(StartNoneEvent.class);
    protected final DefinitionManager definitionManager;
    private final RuleManager ruleManager;
    private final GraphIndexBuilder<?> indexBuilder;
    private final GraphCommandManager graphCommandManager;
    protected final GraphCommandFactory graphCommandFactory;
    protected final FactoryManager factoryManager;
    private Class<? extends BPMNDiagram> diagramType;

    protected BPMNGraphFactoryImpl() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public BPMNGraphFactoryImpl(DefinitionManager definitionManager, FactoryManager factoryManager, RuleManager ruleManager, GraphCommandManager graphCommandManager, GraphCommandFactory graphCommandFactory, GraphIndexBuilder<?> indexBuilder) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
        this.ruleManager = ruleManager;
        this.graphCommandManager = graphCommandManager;
        this.graphCommandFactory = graphCommandFactory;
        this.indexBuilder = indexBuilder;
        this.diagramType = BPMNDiagramImpl.class;
    }

    @Override
    public void setDiagramType(Class<? extends BPMNDiagram> diagramType) {
        this.diagramType = diagramType;
    }

    public Class<? extends BPMNDiagram> getDiagramType() {
        return this.diagramType;
    }

    public Class<? extends ElementFactory> getFactoryType() {
        return BPMNGraphFactory.class;
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definitionSetId) {
        Graph graph = super.build(uuid, definitionSetId);
        List<Command> commands = this.buildInitialisationCommands();
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commands.forEach(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
        this.graphCommandManager.execute((Object)this.createGraphContext(graph), (Command)commandBuilder.build());
        return graph;
    }

    public boolean accepts(String source) {
        return true;
    }

    protected List<Command> buildInitialisationCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Node diagramNode = (Node)this.factoryManager.newElement(UUID.uuid(), BindableAdapterUtils.getDefinitionId(this.diagramType));
        Node startEventNode = (Node)this.factoryManager.newElement(UUID.uuid(), START_EVENT_ID);
        commands.add((Command)this.graphCommandFactory.addNode(diagramNode));
        commands.add((Command)this.graphCommandFactory.addChildNode(diagramNode, startEventNode, new Point2D(100.0, 100.0)));
        return commands;
    }

    protected GraphCommandExecutionContext createGraphContext(Graph graph) {
        Index index = this.indexBuilder.build(graph);
        return new DirectGraphCommandExecutionContext(this.definitionManager, this.factoryManager, index);
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }
}

