/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNUtils;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class DMNScenarioValidation
extends AbstractScenarioValidation {
    public static final DMNScenarioValidation INSTANCE = new DMNScenarioValidation();

    @Override
    public List<FactMappingValidationError> validate(Simulation simulation, KieContainer kieContainer) {
        ArrayList<FactMappingValidationError> errors = new ArrayList<FactMappingValidationError>();
        String dmnFilePath = simulation.getSimulationDescriptor().getDmnFilePath();
        DMNModel dmnModel = this.getDMNModel(kieContainer, dmnFilePath);
        for (FactMapping factMapping : simulation.getSimulationDescriptor().getFactMappings()) {
            DMNType rootDMNType;
            if (DMNScenarioValidation.isToSkip(factMapping)) continue;
            String nodeName = factMapping.getFactIdentifier().getName();
            try {
                rootDMNType = dmnModel.getDecisionByName(nodeName) != null ? dmnModel.getDecisionByName(nodeName).getResultType() : dmnModel.getInputByName(nodeName).getType();
            }
            catch (NullPointerException e) {
                errors.add(FactMappingValidationError.createNodeChangedError((FactMapping)factMapping, (String)"node not found"));
                continue;
            }
            List<String> steps = this.expressionElementToString(factMapping);
            Type rootType = DMNUtils.getRootType((BaseDMNTypeImpl)rootDMNType);
            if (!BuiltInType.CONTEXT.equals((Object)rootType) && steps.isEmpty() && rootDMNType.isComposite()) {
                errors.add(FactMappingValidationError.createNodeChangedError((FactMapping)factMapping, (String)rootDMNType.getName()));
                continue;
            }
            try {
                DMNType fieldType = DMNUtils.navigateDMNType(rootDMNType, steps);
                if (this.isDMNFactMappingValid(factMapping.getClassName(), factMapping, fieldType)) continue;
                errors.add(FactMappingValidationError.createFieldChangedError((FactMapping)factMapping, (String)fieldType.getName()));
            }
            catch (IllegalStateException e) {
                errors.add(FactMappingValidationError.createGenericError((FactMapping)factMapping, (String)e.getMessage()));
            }
        }
        return errors;
    }

    private boolean isDMNFactMappingValid(String typeName, FactMapping factMapping, DMNType dmnType) {
        boolean isCoherent;
        Type rootType = DMNUtils.getRootType((BaseDMNTypeImpl)dmnType);
        boolean bl = isCoherent = BuiltInType.UNKNOWN.equals((Object)rootType) || ScenarioSimulationSharedUtils.isList((String)typeName) == dmnType.isCollection();
        if (!isCoherent) {
            return false;
        }
        String factMappingType = ScenarioSimulationSharedUtils.isList((String)typeName) ? (String)factMapping.getGenericTypes().get(0) : typeName;
        return Objects.equals(factMappingType, dmnType.getName());
    }

    protected DMNModel getDMNModel(KieContainer kieContainer, String dmnPath) {
        return DMNSimulationUtils.extractDMNModel((DMNRuntime)DMNSimulationUtils.extractDMNRuntime((KieContainer)kieContainer), (String)dmnPath);
    }
}

