/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.kie.workbench.common.screens.impl.LibraryIndexer;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Remote;
import org.kie.workbench.common.services.refactoring.model.index.events.IndexingFinishedEvent;
import org.slf4j.Logger;
import org.uberfire.ext.metadata.event.BatchIndexEvent;
import org.uberfire.ext.metadata.event.IndexEvent;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

@ApplicationScoped
public class LibraryAssetUpdateNotifier {
    private final WorkspaceProjectService projectService;
    private final Event<ProjectAssetListUpdated> assetListUpdateEvent;
    private final LibraryIndexer libraryIndexer;
    private final Logger logger;

    public LibraryAssetUpdateNotifier() {
        this(null, null, null, null);
    }

    @Inject
    public LibraryAssetUpdateNotifier(WorkspaceProjectService projectService, LibraryIndexer libraryIndexer, @Remote Event<ProjectAssetListUpdated> assetListUpdateEvent, Logger logger) {
        this.projectService = projectService;
        this.libraryIndexer = libraryIndexer;
        this.assetListUpdateEvent = assetListUpdateEvent;
        this.logger = logger;
    }

    public void notifyOnUpdatedAssets(@Observes @Named(value="org.kie.workbench.common.LibraryAssetIndexer") BatchIndexEvent event) {
        event.getIndexEvents().stream().flatMap(evt -> {
            switch (evt.getKind()) {
                case Deleted: {
                    return Stream.of(((IndexEvent.DeletedEvent)evt).getDeleted().getKey());
                }
                case NewlyIndexed: {
                    return Stream.of(((IndexEvent.NewlyIndexedEvent)evt).getKObject().getKey());
                }
                case Renamed: {
                    return Stream.of(((IndexEvent.RenamedEvent)evt).getTarget().getKey());
                }
            }
            return Stream.empty();
        }).map(path -> Paths.get((String)path, (String[])new String[0])).filter(path -> this.libraryIndexer.supportsPath((Path)path)).flatMap(path -> {
            try {
                WorkspaceProject project = this.projectService.resolveProject(org.uberfire.backend.server.util.Paths.convert((Path)path));
                return project == null ? Stream.empty() : Stream.of(project);
            }
            catch (Throwable t) {
                return Stream.empty();
            }
        }).map(project -> new ProjectAssetListUpdated(project)).findFirst().ifPresent(clientEvent -> {
            this.logger.info("Sending indexing notification for project [{}].", (Object)clientEvent.getProject().getRepository().getIdentifier());
            this.assetListUpdateEvent.fire(clientEvent);
        });
    }

    private void onProjectIndexingFinishedEvent(@Observes IndexingFinishedEvent event) {
        WorkspaceProject project = this.projectService.resolveProject(event.getPath());
        if (project == null) {
            throw new IllegalStateException("Cannot resolve Project for KClusterId: '" + event.getkClusterId() + "' and path: '" + event.getPath().toString() + "'.");
        }
        this.assetListUpdateEvent.fire((Object)new ProjectAssetListUpdated(project));
    }
}

