/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.GenericServiceTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.mockito.Mock;

public class GenericServiceTaskPropertyWriterTest {
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final String SLA_DUE_DATE_CDATA = "<![CDATA[12/25/1983]]>";
    private GenericServiceTaskPropertyWriter w;
    private ServiceTask serviceTask = Factories.bpmn2.createServiceTask();
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;

    @Before
    public void setUp() {
        PropertyWriterFactory writerFactory = new PropertyWriterFactory();
        this.w = writerFactory.of(this.serviceTask);
    }

    @Test
    public void setAndTestJava() {
        this.w.setServiceImplementation("Java");
        this.w.setServiceOperation("setServiceOperation");
        this.w.setServiceInterface("setServiceInterface");
        this.w.setSLADueDate(SLA_DUE_DATE);
        this.w.setAsync(false);
        this.w.setAdHocAutostart(false);
        this.w.setAssignmentsInfo(new AssignmentsInfo());
        Assert.assertEquals((Object)"Java", (Object)CustomAttribute.serviceImplementation.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"setServiceOperation", (Object)CustomAttribute.serviceOperation.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"setServiceInterface", (Object)CustomAttribute.serviceInterface.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)SLA_DUE_DATE_CDATA, (Object)CustomElement.slaDueDate.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.async.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.autoStart.of((BaseElement)this.serviceTask).get());
        Assert.assertNotNull((Object)Scripts.onEntry((Task)this.serviceTask));
    }

    @Test
    public void setAndTestWebService() {
        this.w.setServiceImplementation("WebService");
        this.w.setServiceOperation("setServiceOperation");
        this.w.setServiceInterface("setServiceInterface");
        this.w.setSLADueDate(SLA_DUE_DATE);
        this.w.setAsync(false);
        this.w.setAdHocAutostart(false);
        Assert.assertEquals((Object)"##WebService", (Object)CustomAttribute.serviceImplementation.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"setServiceOperation", (Object)CustomAttribute.serviceOperation.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"setServiceInterface", (Object)CustomAttribute.serviceInterface.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)SLA_DUE_DATE_CDATA, (Object)CustomElement.slaDueDate.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.async.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.autoStart.of((BaseElement)this.serviceTask).get());
    }
}

