/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.ConditionParser;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.ConditionTestCommons;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.Condition;

public class ConditionParserTest {
    @Test
    public void testUnaryFunctionsParsingSuccessful() throws Exception {
        for (String function : ConditionTestCommons.unaryFunctions) {
            this.testUnaryFunctionParsingSuccessful(function);
        }
    }

    @Test
    public void testBinaryFunctionsParsingSuccessful() throws Exception {
        for (String function : ConditionTestCommons.binaryFunctions) {
            this.testBinaryFunctionParsingSuccessful(function);
        }
    }

    @Test
    public void testTernaryFunctionsParsingSuccessful() throws Exception {
        for (String function : ConditionTestCommons.ternaryFunctions) {
            this.testTernaryFunctionParsingSuccessful(function);
        }
    }

    @Test
    public void testUnaryFunctionsParsingUnsuccessful() {
        for (String function : ConditionTestCommons.unaryFunctions) {
            this.testFunctionParsingUnsuccessful(function, ConditionTestCommons.failingUnaryFunctionExpressions);
        }
    }

    @Test
    public void testBinaryFunctionsParsingUnsuccessful() {
        for (String function : ConditionTestCommons.binaryFunctions) {
            this.testFunctionParsingUnsuccessful(function, ConditionTestCommons.failingBinaryFunctionExpressions);
        }
    }

    @Test
    public void testTernaryFunctionsParsingUnsuccessful() {
        for (String function : ConditionTestCommons.ternaryFunctions) {
            this.testFunctionParsingUnsuccessful(function, ConditionTestCommons.failingTernaryFunctionExpressions);
        }
    }

    @Test
    public void testWhiteSpaces() throws Exception {
        String condition;
        Condition expectedCondition = new Condition("between", Arrays.asList("someVariable", "value1", "value2"));
        char[] whiteSpaceChars = new char[]{'\n', '\t', ' ', '\r'};
        String conditionTemplate = "%sreturn%sKieFunctions.between(%ssomeVariable%s,%s\"value1\"%s,%s\"value2\"%s)%s;";
        for (char whiteSpace : whiteSpaceChars) {
            condition = String.format(conditionTemplate, Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace));
            Assert.assertEquals((Object)expectedCondition, (Object)new ConditionParser(condition).parse());
        }
        conditionTemplate = "%sreturn%sKieFunctions.between(%ssomeVariable%s.%ssomeMethod%s(%s)%s,%s\"value1\"%s,%s\"value2\"%s)%s;";
        for (char whiteSpace : whiteSpaceChars) {
            condition = String.format(conditionTemplate, Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace), Character.valueOf(whiteSpace));
            expectedCondition = new Condition("between", Arrays.asList("someVariable.someMethod()", "value1", "value2"));
            Assert.assertEquals((Object)expectedCondition, (Object)new ConditionParser(condition).parse());
        }
    }

    private void testUnaryFunctionParsingSuccessful(String function) throws Exception {
        List<String> conditions = ConditionTestCommons.buildUnaryConditionScripts(function);
        for (int i = 0; i < conditions.size(); ++i) {
            ConditionParser parser = new ConditionParser(conditions.get(i));
            Condition condition = parser.parse();
            Assert.assertEquals((Object)function, (Object)condition.getFunction());
            Assert.assertEquals((long)1L, (long)condition.getParams().size());
            Assert.assertEquals((Object)ConditionTestCommons.variableParams.get(i), condition.getParams().get(0));
        }
    }

    private void testBinaryFunctionParsingSuccessful(String function) throws Exception {
        List<String> conditions = ConditionTestCommons.buildBinaryConditionScripts(function);
        for (int i = 0; i < conditions.size(); ++i) {
            ConditionParser parser = new ConditionParser(conditions.get(i));
            Condition condition = parser.parse();
            Assert.assertEquals((Object)function, (Object)condition.getFunction());
            Assert.assertEquals((long)2L, (long)condition.getParams().size());
            Assert.assertEquals((Object)ConditionTestCommons.variableParams.get(i), condition.getParams().get(0));
            Assert.assertEquals((Object)ConditionTestCommons.stringParams.get(i), condition.getParams().get(1));
        }
    }

    private void testTernaryFunctionParsingSuccessful(String function) throws Exception {
        List<String> conditions = ConditionTestCommons.buildTernaryConditionScripts(function);
        for (int i = 0; i < conditions.size(); ++i) {
            ConditionParser parser = new ConditionParser(conditions.get(i));
            Condition condition = parser.parse();
            Assert.assertEquals((Object)function, (Object)condition.getFunction());
            Assert.assertEquals((long)3L, (long)condition.getParams().size());
            Assert.assertEquals((Object)ConditionTestCommons.variableParams.get(i), condition.getParams().get(0));
            Assert.assertEquals((Object)ConditionTestCommons.stringParams.get(i), condition.getParams().get(1));
            Assert.assertEquals((Object)ConditionTestCommons.stringParams.get(i), condition.getParams().get(2));
        }
    }

    private void testFunctionParsingUnsuccessful(String function, List<String> expressionsSet) {
        for (int i = 0; i < expressionsSet.size(); ++i) {
            String expression = String.format(expressionsSet.get(i), "KieFunctions." + function);
            ConditionParser parser = new ConditionParser(expression);
            try {
                parser.parse();
                Assert.fail((String)("A parsing error was expected for expression at position " + i + ": " + expression));
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

