/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser;

import java.text.ParseException;
import java.util.Arrays;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.forms.conditions.parser.ParsingUtils;

public class ParsingUtilsTest {
    @Test
    public void testParseJavaNameSuccessfulWithStopCharacters() throws Exception {
        char[] stopCharacters = new char[]{' ', '.', '('};
        String[] expectedValues = new String[]{"x", "$", "_name", "_n\u00e4me", "n\u00e4me", "n\u00e4me1"};
        String[] inputs = new String[]{"x    blabla", "$. more things", "_name(", "_n\u00e4me(other stuff", "n\u00e4me.ABCD", "n\u00e4me1"};
        this.testParseJavaNameSuccessful(expectedValues, inputs, stopCharacters);
    }

    @Test
    public void testParseJavaNameOnlyUnderscore() throws Exception {
        Assume.assumeTrue((boolean)this.isJavaVersionOlderThan9());
        char[] stopCharacters = new char[]{' ', '.', '('};
        String[] expectedValues = new String[]{"_", "_", "_", "_"};
        String[] inputs = new String[]{"_    blabla", "_", "_.text", "_(l"};
        this.testParseJavaNameSuccessful(expectedValues, inputs, stopCharacters);
    }

    private boolean isJavaVersionOlderThan9() {
        return SystemUtils.IS_JAVA_1_8 || SystemUtils.IS_JAVA_1_7 || SystemUtils.IS_JAVA_1_6 || SystemUtils.IS_JAVA_1_5 || SystemUtils.IS_JAVA_1_4 || SystemUtils.IS_JAVA_1_3 || SystemUtils.IS_JAVA_1_2 || SystemUtils.IS_JAVA_1_1;
    }

    @Test
    public void testParseJavaNameSuccessfulWithoutStopCharacters() throws Exception {
        String[] inputs;
        char[] stopCharacters = new char[]{};
        String[] expectedValues = inputs = new String[]{"x", "$", "_name", "_n\u00e4me", "n\u00e4me", "n\u00e4me1"};
        this.testParseJavaNameSuccessful(expectedValues, inputs, stopCharacters);
    }

    private void testParseJavaNameSuccessful(String[] expectedValues, String[] inputs, char[] stopCharacters) throws Exception {
        for (int i = 0; i < inputs.length; ++i) {
            Assert.assertEquals((Object)expectedValues[i], (Object)ParsingUtils.parseJavaName((String)inputs[i], (int)0, (char[])stopCharacters));
        }
    }

    @Test
    public void testParseJavaNameFailureWithStopCharacters() throws Exception {
        char[] stopCharacters = new char[]{' ', '.', '('};
        String[] inputs = new String[]{"1    blabla", "1. more things", "int(", "float(other stuff", "static.ABCD", "char ", "boolean.", "&and so on..."};
        this.testParseJavaNameFailure(inputs, stopCharacters);
    }

    @Test
    public void testParseJavaNameFailureWithoutStopCharacters() throws Exception {
        char[] stopCharacters = new char[]{};
        String[] inputs = new String[]{"1", "int", "float", "static", "char ", "boolean", "&and so on..."};
        this.testParseJavaNameFailure(inputs, stopCharacters);
    }

    private void testParseJavaNameFailure(String[] inputs, char[] stopCharacters) {
        Arrays.stream(inputs).forEach(input -> {
            try {
                ParsingUtils.parseJavaName((String)input, (int)0, (char[])stopCharacters);
                Assert.fail((String)("An exception was expected for input value: " + input));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        });
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testParseJavaNameWithLowerOutOfBounds() throws ParseException {
        String someString = "a1234";
        char[] someStopCharacters = new char[]{};
        ParsingUtils.parseJavaName((String)someString, (int)-1, (char[])someStopCharacters);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testParseJavaNameWithHigherOutOfBounds() throws ParseException {
        String someString = "a1234";
        char[] someStopCharacters = new char[]{};
        ParsingUtils.parseJavaName((String)someString, (int)someString.length(), (char[])someStopCharacters);
    }
}

