/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.forms.gen;

import org.eclipse.bpmn2.Definitions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.backend.BPMNBackendService;
import org.kie.workbench.common.stunner.bpmn.backend.BPMNDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.forms.gen.BPMNFormGenerationModelProvider;
import org.kie.workbench.common.stunner.bpmn.backend.forms.gen.util.BPMNFormGenerationModelProviderHelper;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNFormGenerationModelProviderTest {
    private static final String ID = "id";
    @Mock
    private BPMNDirectDiagramMarshaller bpmnDirectDiagramMarshaller;
    @Mock
    private BPMNBackendService bpmnBackendService;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private Diagram diagram;
    @Mock
    private Definitions definitions;
    @Mock
    private Metadata metadata;
    private BPMNFormGenerationModelProvider tested;
    private BPMNFormGenerationModelProviderHelper formGenerationModelProviderHelper;

    @Before
    public void init() {
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)ID);
        Mockito.when((Object)this.definitionUtils.getDefinitionSetId((Class)Matchers.eq(BPMNDefinitionSet.class))).thenReturn((Object)ID);
        this.formGenerationModelProviderHelper = new BPMNFormGenerationModelProviderHelper(this.bpmnBackendService);
        this.tested = new BPMNFormGenerationModelProvider(this.definitionUtils, this.formGenerationModelProviderHelper);
        this.tested.init();
        ((DefinitionUtils)Mockito.verify((Object)this.definitionUtils)).getDefinitionSetId((Class)Matchers.eq(BPMNDefinitionSet.class));
    }

    @Test
    public void testAccepts() {
        Assert.assertTrue((boolean)this.tested.accepts(this.diagram));
    }

    @Test
    public void testGenerateForBPMNDDirectDiagramMarshaller() throws Exception {
        Mockito.when((Object)this.bpmnDirectDiagramMarshaller.marshallToBpmn2Definitions(this.diagram)).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.bpmnBackendService.getDiagramMarshaller()).thenReturn((Object)this.bpmnDirectDiagramMarshaller);
        Definitions result = this.tested.generate(this.diagram);
        ((BPMNDirectDiagramMarshaller)Mockito.verify((Object)this.bpmnDirectDiagramMarshaller, (VerificationMode)Mockito.times((int)1))).marshallToBpmn2Definitions((Diagram)Matchers.eq((Object)this.diagram));
        Assert.assertEquals((Object)result, (Object)this.definitions);
    }
}

