/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.stunner.bpmn.backend.service.FindDataTypesService;
import org.kie.workbench.common.stunner.bpmn.service.DataTypesService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class FindDataTypesServiceTest {
    @Mock
    private DataModelService dataModelService;
    @Mock
    private PackageDataModelOracle oracle;
    @Mock
    private Path path;
    private DataTypesService service;

    @Before
    public void setup() {
        this.service = new FindDataTypesService(this.dataModelService);
    }

    @Test
    public void testGetJavaTypeNames() throws Exception {
        HashMap<String, ModelField[]> fields = new HashMap<String, ModelField[]>();
        Mockito.when((Object)this.oracle.getModulePackageNames()).thenReturn(Collections.singletonList("org"));
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.oracle);
        fields.put("org.Zebra", new ModelField[]{new ModelField("this", "org.Zebra", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this")});
        fields.put("org.Antelope", new ModelField[]{new ModelField("this", "org.Antelope", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this")});
        fields.put("smurf.Pupa", new ModelField[]{new ModelField("this", "smurf.Pupa", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this")});
        Mockito.when((Object)this.oracle.getModuleModelFields()).thenReturn(fields);
        List dataTypeNames = this.service.getDataTypeNames(this.path);
        Assert.assertNotNull((Object)dataTypeNames);
        Assert.assertEquals((long)2L, (long)dataTypeNames.size());
        Assert.assertEquals((Object)"org.Antelope", dataTypeNames.get(0));
        Assert.assertEquals((Object)"org.Zebra", dataTypeNames.get(1));
    }
}

