/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class CatchingIntermediateTimerEventTest
extends CatchingIntermediateEventTest<IntermediateTimerEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/catchingIntermediateTimerEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "008E111E-E0EF-40F6-891F-FC0E9C2B9CEC";
    private static final String FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID = "750BF5E5-B718-4B21-B86F-B4D55176403A";
    private static final String FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID = "FDE8EFB6-6899-4074-AADD-5FEBAA90AE79";
    private static final String FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID = "AA31C768-7CA4-456B-A3A3-A55CE0998FF8";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "55C242C9-1C54-45F4-9915-DE307C82EFC8";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID = "05B04BBC-E071-478C-9927-008290802507";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID = "8DC9B6AF-B8E3-491A-B440-DC9E5BD47EE3";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID = "3B7F8E55-5110-4355-B0B7-07CEB00AA0D3";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "A2D7D12D-D33F-4419-A279-4641E0542CF6";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_AFTER_DURATION_ID = "822849A7-4DBD-4BAD-8C84-63D5676E667F";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_MULTIPLE_ID = "1549183C-9E76-4EF3-8C7B-40B18FD122EE";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID = "E6D87D0A-C10B-4861-A8B0-671F34441696";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "5C60A844-2BE4-4FE6-91DE-62E547400681";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID = "65978DFE-39BB-4279-8812-364D092BF92A";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID = "F50012CC-6345-489B-8052-6BB895163C20";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID = "3B5B9E49-E238-485D-9303-8BD0B3310D94";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 45;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_AFTER_DURATION = "timer01 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "timer01 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "timer03 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_MULTIPLE = "timer03 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_MULTIPLE = "5m10s";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "cron";
        String EVENT_NAME_SPECIFIC_DATE = "timer02 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "timer02 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:10:27+02:00";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent filledTopEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID, false, 0);
        this.assertGeneralSet(filledTopEventAfterDuration.getGeneral(), "timer01 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer01 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventAfterDuration(filledTopEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID, false, 0);
        this.assertGeneralSet(filledTopEventMultiple.getGeneral(), "timer03 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer03 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventMultiple(filledTopEventMultiple.getExecutionSet(), "5m10s", "cron", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID, false, 0);
        this.assertGeneralSet(filledTopEventSpecificDate.getGeneral(), "timer02 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer02 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventSpecificDate(filledTopEventSpecificDate.getExecutionSet(), "2018-08-13T15:10:27+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent emptyTopEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptyTopEvent.getExecutionSet(), true, "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME_AFTER_DURATION = "timer04 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "timer04 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "timer06 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_MULTIPLE = "timer06 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_MULTIPLE = "R3/PT8M3S";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "none";
        String EVENT_NAME_SPECIFIC_DATE = "timer05 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "timer05 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:05:02+02:00";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent filledTopEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_AFTER_DURATION_ID, true, 2);
        this.assertGeneralSet(filledTopEventAfterDuration.getGeneral(), "timer04 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer04 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventAfterDuration(filledTopEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_MULTIPLE_ID, true, 2);
        this.assertGeneralSet(filledTopEventMultiple.getGeneral(), "timer06 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer06 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventMultiple(filledTopEventMultiple.getExecutionSet(), "R3/PT8M3S", "none", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID, true, 2);
        this.assertGeneralSet(filledTopEventSpecificDate.getGeneral(), "timer05 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer05 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventSpecificDate(filledTopEventSpecificDate.getExecutionSet(), "2018-08-13T15:05:02+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent emptyEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptyEvent.getExecutionSet(), true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_AFTER_DURATION = "timer07 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "timer07 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "timer09 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_MULTIPLE = "timer09 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_MULTIPLE = "R3/PT8M3S";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "none";
        String EVENT_NAME_SPECIFIC_DATE = "timer08 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "timer08 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T16:20:14+02:00";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent filledSubprocessEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEventAfterDuration.getGeneral(), "timer07 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer07 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventAfterDuration(filledSubprocessEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledSubprocessEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEventMultiple.getGeneral(), "timer09 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer09 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventMultiple(filledSubprocessEventMultiple.getExecutionSet(), "R3/PT8M3S", "none", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledSubprocessEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEventSpecificDate.getGeneral(), "timer08 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer08 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventSpecificDate(filledSubprocessEventSpecificDate.getExecutionSet(), "2018-08-13T16:20:14+02:00", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent emptySubprocessEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptySubprocessEvent.getExecutionSet(), true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent emptySubprocessEvent = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptySubprocessEvent.getExecutionSet(), true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME_AFTER_DURATION = "timer10 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "timer10 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        String EVENT_NAME_MULTIPLE = "timer12 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_MULTIPLE = "timer12 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_MULTIPLE = "5m4s";
        String EVENT_TIMER_VALUE_LANGUAGE_MULTIPLE = "cron";
        String EVENT_NAME_SPECIFIC_DATE = "timer11 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "timer11 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?";
        String EVENT_TIMER_VALUE_SPECIFIC_DATE = "2018-08-13T15:35:13+02:00";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 45);
        IntermediateTimerEvent filledTopEventAfterDuration = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, true, 2);
        this.assertGeneralSet(filledTopEventAfterDuration.getGeneral(), "timer10 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer10 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventAfterDuration(filledTopEventAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventMultiple = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, true, 2);
        this.assertGeneralSet(filledTopEventMultiple.getGeneral(), "timer12 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer12 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventMultiple(filledTopEventMultiple.getExecutionSet(), "5m4s", "cron", true, SLA_DUE_DATE);
        IntermediateTimerEvent filledTopEventSpecificDate = (IntermediateTimerEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID, true, 2);
        this.assertGeneralSet(filledTopEventSpecificDate.getGeneral(), "timer11 name ~!@#$%^&*()_+-=[]\\{}|;':\",./<>?`", "timer11 doc\n ~!@#$%^&*()_+`1234567890-=[]\\{}|;':\",./<>?");
        this.assertTimerEventSpecificDate(filledTopEventSpecificDate.getExecutionSet(), "2018-08-13T15:35:13+02:00", true, SLA_DUE_DATE);
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateTimerEvent> getCatchingIntermediateEventType() {
        return IntermediateTimerEvent.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID, FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID, FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_AFTER_DURATION_ID, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_MULTIPLE_ID, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertTimerEventMultiple(CancellingTimerEventExecutionSet executionSet, String timerValue, String timeCycleLanguage, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getTimerSettings()).isNotNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycle()).isEqualTo((Object)timerValue);
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycleLanguage()).isEqualTo((Object)timeCycleLanguage);
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDuration()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDate()).isNull();
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventAfterDuration(CancellingTimerEventExecutionSet executionSet, String timerValue, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getTimerSettings()).isNotNull();
        Assertions.assertThat((Object)executionSet.getCancelActivity()).isNotNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDuration()).isEqualTo((Object)timerValue);
        Assertions.assertThat((Boolean)executionSet.getCancelActivity().getValue()).isEqualTo(isCancelling);
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDate()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycle()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycleLanguage()).isNull();
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventSpecificDate(CancellingTimerEventExecutionSet executionSet, String dateValue, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getTimerSettings()).isNotNull();
        Assertions.assertThat((Object)executionSet.getCancelActivity()).isNotNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDate()).isEqualTo((Object)dateValue);
        Assertions.assertThat((Boolean)executionSet.getCancelActivity().getValue()).isEqualTo(isCancelling);
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycle()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDuration()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycleLanguage()).isNull();
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventEmpty(CancellingTimerEventExecutionSet executionSet, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getTimerSettings()).isNotNull();
        Assertions.assertThat((Object)executionSet.getCancelActivity()).isNotNull();
        Assertions.assertThat((Boolean)executionSet.getCancelActivity().getValue()).isEqualTo(isCancelling);
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDate()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycle()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeDuration()).isNull();
        Assertions.assertThat((String)executionSet.getTimerSettings().getValue().getTimeCycleLanguage()).isNull();
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

