/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import java.io.InputStream;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Task;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.Unmarshalling;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class ServiceTaskTest
extends BPMNDiagramMarshallerBaseTest {
    private static final String BPMN_SERVICE_TASK_PROPERTIES_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/serviceTask.bpmn";
    private static final String SERVICE_TASK_ID = "A3C25100-DFAB-4867-9282-08381BD69C6B";

    @Test
    public void testBasicUnmarshall() throws Exception {
        Diagram<Graph, Metadata> d = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_SERVICE_TASK_PROPERTIES_FILE_PATH);
        Node node = d.getGraph().getNode(SERVICE_TASK_ID);
        ServiceTask definition = (ServiceTask)((View)node.getContent()).getDefinition();
        Assert.assertEquals((Object)"Custom Email", (Object)definition.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"This is an email task", (Object)definition.getGeneral().getDocumentation().getValue());
    }

    @Test
    public void testBasicMarshall() throws Exception {
        Diagram<Graph, Metadata> d = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_SERVICE_TASK_PROPERTIES_FILE_PATH);
        Definitions definitions = this.convertToDefinitions(d);
        Task serviceTask = ((Process)definitions.getRootElements().get(0)).getFlowElements().stream().filter(Task.class::isInstance).map(Task.class::cast).findFirst().get();
        Assert.assertEquals((Object)"Custom Email", (Object)serviceTask.getName());
        Assert.assertEquals((Object)"<![CDATA[This is an email task]]>", (Object)((Documentation)serviceTask.getDocumentation().get(0)).getText());
    }

    @Test
    public void testBasicBidi() throws Exception {
        Diagram<Graph, Metadata> d = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_SERVICE_TASK_PROPERTIES_FILE_PATH);
        String marshall = this.marshaller.marshall(d);
        Diagram<Graph, Metadata> d2 = Unmarshalling.unmarshall((DiagramMarshaller)this.marshaller, (InputStream)new StringInputStream(marshall));
        Node node = d2.getGraph().getNode(SERVICE_TASK_ID);
        ServiceTask definition = (ServiceTask)((View)node.getContent()).getDefinition();
        Assert.assertEquals((Object)"Custom Email", (Object)definition.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"This is an email task", (Object)definition.getGeneral().getDocumentation().getValue());
    }
}

