/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiPredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy.WorkItemDefinitionDeployServices;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionBackendService;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionVFSLookupService;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionCacheRegistry;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkItemDefinitionBackendServiceTest {
    private static WorkItemDefinition wid1 = new WorkItemDefinition().setName("wid1");
    private static WorkItemDefinition wid2 = new WorkItemDefinition().setName("wid2");
    @Mock
    private WorkItemDefinitionVFSLookupService vfsService;
    @Mock
    private WorkItemDefinitionDeployServices deployServices;
    @Mock
    private BiPredicate<Metadata, Collection<WorkItemDefinition>> deployPredicate;
    @Mock
    private Metadata metadata;
    private WorkItemDefinitionBackendService tested;
    private WorkItemDefinitionCacheRegistry registry;

    @Before
    public void init() {
        Mockito.when((Object)this.vfsService.search((Metadata)Matchers.eq((Object)this.metadata))).thenReturn(Arrays.asList(wid1, wid2));
        this.registry = new WorkItemDefinitionCacheRegistry();
        this.tested = new WorkItemDefinitionBackendService(this.registry, this.vfsService, this.deployServices, this.deployPredicate);
    }

    @Test
    public void testGetRegistry() {
        Assert.assertEquals((Object)this.registry, (Object)this.tested.getRegistry());
    }

    @Test
    public void testExecute() {
        Collection result = this.tested.execute(this.metadata);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(wid1));
        Assert.assertTrue((boolean)result.contains(wid2));
    }

    @Test
    public void testDestroy() {
        this.tested.execute(this.metadata);
        Assert.assertFalse((boolean)this.registry.isEmpty());
        this.tested.destroy();
        Assert.assertTrue((boolean)this.registry.isEmpty());
    }
}

