var serviceinfo = [
{
        "name" : "Archive",
        "displayName" : "Archive",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.archive.ArchiveWorkItemHandler()",
        "documentation" : "archive-workitem/index.html",
        "module" : "archive-workitem",
        "icon" : "Archive.png",
            "category" : "Archive",
            "description" : "Archive a list of files",
            "keywords" : [
                                "archive"
                ,"file"
                ,"files"
                ,"zip"

            ],
                "isaction" : "true",
                "actiontitle" : "Archive a list of files.",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "Archive",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Files",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "archive-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "CamelGenericConnector",
        "displayName" : "CamelGenericConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.GenericCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelGenericConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Send payload to a Camel endpoint",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "path",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelSQLConnector",
        "displayName" : "CamelSQLConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.SQLCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelSQLConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"sql"
                ,"database"
                ,"jdbc"
                ,"query"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute SQL query at a Camel endpoint and retrieve results",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "query",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelFileConnector",
        "displayName" : "CamelFileConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.FileCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelFileConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"file"
                ,"filysystem"
                ,"read"
                ,"write"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Access file systems and process files",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "path",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "fileName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelFTPConnector",
        "displayName" : "CamelFTPConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.FTPCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelFTPConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"ftp"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Access remote file system over FTP",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "hostname",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "password",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "port",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "directoryname",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "CamelFileName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "username",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelJMSConnector",
        "displayName" : "CamelJMSConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.JMSCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelJMSConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"jms"
                ,"queue"
                ,"topic"
                ,"message"
                ,"send"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Send message to a JMS Queue or Topic",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "destinationName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelFTPSConnector",
        "displayName" : "CamelFTPSConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.FTPSCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelFTPSConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"ftp"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Access remote file system over FTPS",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "hostName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "password",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "port",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "userName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "directoryName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelXSLTConnector",
        "displayName" : "CamelXSLTConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.XSLTCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelXSLTConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"xslt"
                ,"template"
                ,"message"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Process a message using an XSLT template",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "templateName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CamelCXFConnector",
        "displayName" : "CamelCXFConnector",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.camel.CXFCamelWorkitemHandler()",
        "documentation" : "camel-workitem/index.html",
        "module" : "camel-workitem",
        "icon" : "CamelCXFConnector.png",
            "category" : "Camel",
            "description" : "Use Apache Camel connectors in your processes",
            "keywords" : [
                                "apache"
                ,"camel"
                ,"cxf"
                ,"payload"
                ,"route"
                ,"connector"

            ],
                "isaction" : "true",
                "actiontitle" : "Connect to a JAX-WS service hosted in CXF",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "address",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "serviceClass",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "payload",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "portName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "serviceName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "response",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "camel-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "DockerKillContainer",
        "displayName" : "DockerKillContainer",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.KillContainerWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerKillContainer.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"kill"
                ,"container"

            ],
                "isaction" : "true",
                "actiontitle" : "Kill Docker container",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "ContainerId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DockerInspectContainer",
        "displayName" : "DockerInspectContainer",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.InspectContainerWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerInspectContainer.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"inspect"
                ,"container"

            ],
                "isaction" : "true",
                "actiontitle" : "Inspect Docker container",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "ContainerId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "ContainerInfo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DockerStartContainer",
        "displayName" : "DockerStartContainer",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.StartContainerWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerStartContainer.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"start"
                ,"container"

            ],
                "isaction" : "true",
                "actiontitle" : "Start Docker container",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "ContainerId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DockerStopContainer",
        "displayName" : "DockerStopContainer",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.StopContainerWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerStopContainer.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"stop"
                ,"container"

            ],
                "isaction" : "true",
                "actiontitle" : "Stop Docker container",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "ContainerId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DockerListContainers",
        "displayName" : "DockerListContainers",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.ListContainersWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerListContainers.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"list"
                ,"containers"

            ],
                "isaction" : "true",
                "actiontitle" : "List Docker containers",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "StatusFilter",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Containers",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DockerCreateContainer",
        "displayName" : "DockerCreateContainer",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.CreateContainerWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerCreateContainer.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"create"
                ,"container"

            ],
                "isaction" : "true",
                "actiontitle" : "Create Docker container",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "ContainerCommand",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContainerImageName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContainerName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContainerHostName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContainerBinds",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContainerEnv",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContainerPortBindings",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "ContainerId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DockerListImages",
        "displayName" : "DockerListImages",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.docker.ListImagesWorkitemHandler()",
        "documentation" : "docker-workitem/index.html",
        "module" : "docker-workitem",
        "icon" : "DockerListImages.png",
            "category" : "Docker",
            "description" : "Connect to and interact with a running Docker deamon",
            "keywords" : [
                                "Docker"
                ,"list"
                ,"images"

            ],
                "isaction" : "true",
                "actiontitle" : "List Docker images",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "ShowAll",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Images",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "docker-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "DropboxUploadFile",
        "displayName" : "DropboxUploadFile",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.dropbox.UploadFileWorkitemHandler(\"clientIdentifier\", \"accessToken\")",
        "documentation" : "dropbox-workitem/index.html",
        "module" : "dropbox-workitem",
        "icon" : "DropboxUploadFile.png",
            "category" : "Dropbox",
            "description" : "Upload and download files from Dropbox",
            "keywords" : [
                                "DropBox"
                ,"file"
                ,"files"
                ,"upload"
                ,"document"
                ,"documents"

            ],
                "isaction" : "true",
                "actiontitle" : "Download a file from DropBox",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Dropbox client identifier"
                                           }
                    ,{
                                               "name" : "Dropbox access token"
                                           }

                ],
                "authreferencesite" : "https://www.dropbox.com/lp/developers",
            "parameters" : [
                                   {
                                       "name" : "Path",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Document",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "dropbox-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DropboxDownloadFile",
        "displayName" : "DropboxDownloadFile",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.dropbox.DownloadFileWorkitemHandler(\"clientIdentifier\", \"accessToken\")",
        "documentation" : "dropbox-workitem/index.html",
        "module" : "dropbox-workitem",
        "icon" : "DropboxDownloadFile.png",
            "category" : "Dropbox",
            "description" : "Upload and download files from Dropbox",
            "keywords" : [
                                "DropBox"
                ,"file"
                ,"files"
                ,"download"
                ,"document"
                ,"documents"

            ],
                "isaction" : "true",
                "actiontitle" : "Upload a file to DropBox",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Dropbox client identifier"
                                           }
                    ,{
                                               "name" : "Dropbox access token"
                                           }

                ],
                "authreferencesite" : "https://www.dropbox.com/lp/developers",
            "parameters" : [
                                   {
                                       "name" : "DocumentPath",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Document",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "dropbox-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "EthereumQueryExistingContract",
        "displayName" : "EthereumQueryExistingContract",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ethereum.QueryExistingContractWorkitemHandler(\"walletPassword\", \"walletPath\")",
        "documentation" : "ethereum-workitem/index.html",
        "module" : "ethereum-workitem",
        "icon" : "EthereumQueryExistingContract.png",
            "category" : "Ethereum",
            "description" : "Integrate with the Ethereum Blockchain app platform",
            "keywords" : [
                                "Ethereum"
                ,"blockchain"
                ,"smart"
                ,"contract"
                ,"smartcontract"
                ,"query"

            ],
                "isaction" : "true",
                "actiontitle" : "Query an existing contract deployed on the blockchain",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Wallet password"
                                           }
                    ,{
                                               "name" : "Path to the wallet file"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "MethodOutputType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ServiceURL",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContractMethodName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContractAddress",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ethereum-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "EthereumObserveContractEvent",
        "displayName" : "EthereumObserveContractEvent",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ethereum.ObserveContractEventWorkitemHandler()",
        "documentation" : "ethereum-workitem/index.html",
        "module" : "ethereum-workitem",
        "icon" : "EthereumObserveContractEvent.png",
            "category" : "Ethereum",
            "description" : "Integrate with the Ethereum Blockchain app platform",
            "keywords" : [
                                "Ethereum"
                ,"blockchain"
                ,"smart"
                ,"contract"
                ,"smartcontract"
                ,"observe"

            ],
                "istrigger" : "true",
                "triggertitle" : "Observe a smart contract deployed onto the blockchain",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "SignalName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventReturnType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ServiceURL",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventIndexedParameter",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventNonIndexedParameter",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "AbortOnUpdate",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContractAddress",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ethereum-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "EthereumTransactExistingContract",
        "displayName" : "EthereumTransactExistingContract",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ethereum.TransactExistingContractWorkitemHandler(\"walletPassword\", \"walletPath\")",
        "documentation" : "ethereum-workitem/index.html",
        "module" : "ethereum-workitem",
        "icon" : "EthereumTransactExistingContract.png",
            "category" : "Ethereum",
            "description" : "Integrate with the Ethereum Blockchain app platform",
            "keywords" : [
                                "Ethereum"
                ,"blockchain"
                ,"smart"
                ,"contract"
                ,"smartcontract"
                ,"transaction"
                ,"send"

            ],
                "isaction" : "true",
                "actiontitle" : "Perform a transaction to an existing contract on the blockchain",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Wallet password"
                                           }
                    ,{
                                               "name" : "Path to the wallet file"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "MethodInputType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "WaitForReceipt",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "DepositAmount",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ServiceURL",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "MethodName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContractAddress",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Receipt",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ethereum-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "EthereumSendEther",
        "displayName" : "EthereumSendEther",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ethereum.SendEtherWorkitemHandler(\"walletPassword\", \"walletPath\")",
        "documentation" : "ethereum-workitem/index.html",
        "module" : "ethereum-workitem",
        "icon" : "EthereumSendEther.png",
            "category" : "Ethereum",
            "description" : "Integrate with the Ethereum Blockchain app platform",
            "keywords" : [
                                "Ethereum"
                ,"blockchain"
                ,"smart"
                ,"contract"
                ,"smartcontract"
                ,"send"
                ,"ether"

            ],
                "isaction" : "true",
                "actiontitle" : "Send ether to an existing contract on the blockchain",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Wallet password"
                                           }
                    ,{
                                               "name" : "Path to the wallet file"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "Amount",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ServiceURL",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ToAddress",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Receipt",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ethereum-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "EthereumDeployContract",
        "displayName" : "EthereumDeployContract",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ethereum.DeployContractWorkitemHandler(\"walletPassword\", \"walletPath\")",
        "documentation" : "ethereum-workitem/index.html",
        "module" : "ethereum-workitem",
        "icon" : "EthereumDeployContract.png",
            "category" : "Ethereum",
            "description" : "Integrate with the Ethereum Blockchain app platform",
            "keywords" : [
                                "Ethereum"
                ,"blockchain"
                ,"smart"
                ,"contract"
                ,"smartcontract"
                ,"deploy"

            ],
                "isaction" : "true",
                "actiontitle" : "Deploy a new smart contract onto the blockchain",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Wallet password"
                                           }
                    ,{
                                               "name" : "Path to the wallet file"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "WaitForReceipt",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "DepositAmount",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContractPath",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ServiceURL",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "ContractAddress",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ethereum-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "EthereumGetBalance",
        "displayName" : "EthereumGetBalance",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ethereum.GetBalanceWorkitemHandler(\"walletPassword\", \"walletPath\")",
        "documentation" : "ethereum-workitem/index.html",
        "module" : "ethereum-workitem",
        "icon" : "EthereumGetBalance.png",
            "category" : "Ethereum",
            "description" : "Integrate with the Ethereum Blockchain app platform",
            "keywords" : [
                                "Ethereum"
                ,"blockchain"
                ,"smart"
                ,"contract"
                ,"smartcontract"
                ,"balance"

            ],
                "isaction" : "true",
                "actiontitle" : "Get your Ether balance from blockchain",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Wallet password"
                                           }
                    ,{
                                               "name" : "Path to the wallet file"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "ServiceURL",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Balance",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ethereum-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Exec",
        "displayName" : "Exec",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.exec.ExecWorkItemHandler()",
        "documentation" : "exec-workitem/index.html",
        "module" : "exec-workitem",
        "icon" : "Exec.png",
            "category" : "Exec",
            "description" : "Execute a command",
            "keywords" : [
                                "execute"
                ,"comand"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute a command",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "Command",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Arguments",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Output",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "exec-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "ExecuteSQL",
        "displayName" : "ExecuteSQL",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.executesql.ExecuteSqlWorkItemHandler(\"dataSourceName\")",
        "documentation" : "execute-sql-workitem/index.html",
        "module" : "execute-sql-workitem",
        "icon" : "ExecuteSQL.png",
            "category" : "Execute SQL",
            "description" : "Execute SQL statements",
            "keywords" : [
                                "database"
                ,"fetch"
                ,"sql"
                ,"execute"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute SQL statements",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Data source JNDI"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "MaxResults",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ColumnSeparator",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SQLStatement",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "execute-sql-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "FTP",
        "displayName" : "FTP",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ftp.FTPUploadWorkItemHandler()",
        "documentation" : "ftp-workitem/index.html",
        "module" : "ftp-workitem",
        "icon" : "FTP.png",
            "category" : "FTP",
            "description" : "Upload a file via FTP",
            "keywords" : [
                                "ftp"
                ,"file"
                ,"upload"

            ],
                "isaction" : "true",
                "actiontitle" : "Upload a file using FTP",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "FilePath",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "User",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "File",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Password",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ftp-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GithubForkRepository",
        "displayName" : "GithubForkRepository",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.github.ForkRepositoryWorkitemHandler(\"userName\", \"password\")",
        "documentation" : "github-workitem/index.html",
        "module" : "github-workitem",
        "icon" : "GithubForkRepository.png",
            "category" : "Github",
            "description" : "Create Gist or list your repositories in Github",
            "keywords" : [
                                "github"
                ,"repo"
                ,"repository"
                ,"fork"

            ],
                "isaction" : "true",
                "actiontitle" : "Fork a GitHub repository",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Github username"
                                           }
                    ,{
                                               "name" : "Github password"
                                           }

                ],
                "authreferencesite" : "https://github.com/",
            "parameters" : [
                                   {
                                       "name" : "Organization",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "RepoOwner",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "RepoName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "ForkedRepoInfo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "github-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GithubMergePullRequest",
        "displayName" : "GithubMergePullRequest",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.github.MergePullRequestWorkitemHandler(\"userName\", \"password\")",
        "documentation" : "github-workitem/index.html",
        "module" : "github-workitem",
        "icon" : "GithubMergePullRequest.png",
            "category" : "Github",
            "description" : "Create Gist or list your repositories in Github",
            "keywords" : [
                                "github"
                ,"repo"
                ,"repository"
                ,"merge"
                ,"pull"
                ,"request"
                ,"pullrequest"
                ,"pr"

            ],
                "isaction" : "true",
                "actiontitle" : "Merget a pull request on GitHub",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Github username"
                                           }
                    ,{
                                               "name" : "Github password"
                                           }

                ],
                "authreferencesite" : "https://github.com/",
            "parameters" : [
                                   {
                                       "name" : "CommitMessage",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "RepoOwner",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "RepoName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "PullRequestNum",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "IsMerged",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "github-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GithubCreateGist",
        "displayName" : "GithubCreateGist",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.github.CreateGistWorkitemHandler(\"userName\", \"password\")",
        "documentation" : "github-workitem/index.html",
        "module" : "github-workitem",
        "icon" : "GithubCreateGist.png",
            "category" : "Github",
            "description" : "Create Gist or list your repositories in Github",
            "keywords" : [
                                "gist"
                ,"github"
                ,"create"

            ],
                "isaction" : "true",
                "actiontitle" : "Create a new Gist",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Github username"
                                           }
                    ,{
                                               "name" : "Github password"
                                           }

                ],
                "authreferencesite" : "https://github.com/",
            "parameters" : [
                                   {
                                       "name" : "Description",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Content",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "IsPublic",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "GistURL",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "github-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GithubFetchIssues",
        "displayName" : "GithubFetchIssues",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.github.FetchIssuesWorkitemHandler(\"userName\", \"password\")",
        "documentation" : "github-workitem/index.html",
        "module" : "github-workitem",
        "icon" : "GithubFetchIssues.png",
            "category" : "Github",
            "description" : "Create Gist or list your repositories in Github",
            "keywords" : [
                                "github"
                ,"repo"
                ,"repository"
                ,"fetch"
                ,"issues"

            ],
                "isaction" : "true",
                "actiontitle" : "Fetch issues for a project from GitHub",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Github username"
                                           }
                    ,{
                                               "name" : "Github password"
                                           }

                ],
                "authreferencesite" : "https://github.com/",
            "parameters" : [
                                   {
                                       "name" : "IssuesState",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "User",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "RepoName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "IssuesList",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "github-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GithubListRepositories",
        "displayName" : "GithubListRepositories",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.github.ListRepositoriesWorkitemHandler(\"userName\", \"password\")",
        "documentation" : "github-workitem/index.html",
        "module" : "github-workitem",
        "icon" : "GithubListRepositories.png",
            "category" : "Github",
            "description" : "Create Gist or list your repositories in Github",
            "keywords" : [
                                "github"
                ,"repo"
                ,"repository"
                ,"list"

            ],
                "isaction" : "true",
                "actiontitle" : "List all GitHub repositories",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Github username"
                                           }
                    ,{
                                               "name" : "Github password"
                                           }

                ],
                "authreferencesite" : "https://github.com/",
            "parameters" : [
                                   {
                                       "name" : "User",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "RepoListInfo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "github-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleAddCalendar",
        "displayName" : "GoogleAddCalendar",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.calendar.AddCalendarWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-calendar-workitem/index.html",
        "module" : "google-calendar-workitem",
        "icon" : "GoogleAddCalendar.png",
            "category" : "Google Calendar",
            "description" : "Add and retrieve Calendars and Calendar Events from Google",
            "keywords" : [
                                "google"
                ,"calendar"
                ,"add"

            ],
                "isaction" : "true",
                "actiontitle" : "Add a new Google Calendar",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/calendar/auth",
            "parameters" : [
                                   {
                                       "name" : "CalendarSummary",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Calendar",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-calendar-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleGetCalendars",
        "displayName" : "GoogleGetCalendars",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.calendar.GetCalendarsWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-calendar-workitem/index.html",
        "module" : "google-calendar-workitem",
        "icon" : "GoogleGetCalendars.png",
            "category" : "Google Calendar",
            "description" : "Add and retrieve Calendars and Calendar Events from Google",
            "keywords" : [
                                "google"
                ,"calendar"
                ,"get"
                ,"all"

            ],
                "isaction" : "true",
                "actiontitle" : "Get all existing Google Calendars",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/calendar/auth",
            "results" : [
                                   {
                                       "name" : "AllCalendars",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-calendar-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleAddEvent",
        "displayName" : "GoogleAddEvent",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.calendar.AddEventWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-calendar-workitem/index.html",
        "module" : "google-calendar-workitem",
        "icon" : "GoogleAddEvent.png",
            "category" : "Google Calendar",
            "description" : "Add and retrieve Calendars and Calendar Events from Google",
            "keywords" : [
                                "google"
                ,"calendar"
                ,"add"
                ,"event"

            ],
                "isaction" : "true",
                "actiontitle" : "Add a new event to existing Google Calendar",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/calendar/auth",
            "parameters" : [
                                   {
                                       "name" : "CalendarSummary",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventSummary",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventStart",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventEnd",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventCreator",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "EventAttendees",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Event",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-calendar-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleGetEvents",
        "displayName" : "GoogleGetEvents",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.calendar.GetEventsWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-calendar-workitem/index.html",
        "module" : "google-calendar-workitem",
        "icon" : "GoogleGetEvents.png",
            "category" : "Google Calendar",
            "description" : "Add and retrieve Calendars and Calendar Events from Google",
            "keywords" : [
                                "google"
                ,"calendar"
                ,"events"
                ,"get"
                ,"all"

            ],
                "isaction" : "true",
                "actiontitle" : "Get all events from an existing Google Calendars",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/calendar/auth",
            "parameters" : [
                                   {
                                       "name" : "CalendarSummary",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "AllEvents",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-calendar-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleDownloadFromDrive",
        "displayName" : "GoogleDownloadFromDrive",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.drive.MediaDownloadWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-drive-workitem/index.html",
        "module" : "google-drive-workitem",
        "icon" : "GoogleDownloadFromDrive.png",
            "category" : "Google Drive",
            "description" : "Upload and download media to/from Google Drive",
            "keywords" : [
                                "google"
                ,"drive"
                ,"media"
                ,"download"

            ],
                "isaction" : "true",
                "actiontitle" : "Download media from Google Drive",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/drive/api/v3/about-auth",
            "parameters" : [
                                   {
                                       "name" : "DocumentPath",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Document",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-drive-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleUploadToDrive",
        "displayName" : "GoogleUploadToDrive",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.drive.MediaUploadWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-drive-workitem/index.html",
        "module" : "google-drive-workitem",
        "icon" : "GoogleUploadToDrive.png",
            "category" : "Google Drive",
            "description" : "Upload and download media to/from Google Drive",
            "keywords" : [
                                "google"
                ,"drive"
                ,"media"
                ,"upload"

            ],
                "isaction" : "true",
                "actiontitle" : "Upload media to Google Drive",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/drive/api/v3/about-auth",
            "parameters" : [
                                   {
                                       "name" : "UploadPath",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "DocMimeType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "DocToUpload",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-drive-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleSendMail",
        "displayName" : "GoogleSendMail",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.mail.SendMailWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-mail-workitem/index.html",
        "module" : "google-mail-workitem",
        "icon" : "GoogleSendMail.png",
            "category" : "Google Mail",
            "description" : "Send mail via Google",
            "keywords" : [
                                "google"
                ,"mail"
                ,"email"
                ,"send"

            ],
                "isaction" : "true",
                "actiontitle" : "Send email using Google Mail",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/gmail/api/auth/about-auth",
            "parameters" : [
                                   {
                                       "name" : "BodyText",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Attachment",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "To",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "From",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Subject",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Message",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-mail-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleMapsSpeedLimits",
        "displayName" : "GoogleMapsSpeedLimits",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.maps.SpeedLimitsWorkitemHandler(\"apiKey\")",
        "documentation" : "google-maps-workitem/index.html",
        "module" : "google-maps-workitem",
        "icon" : "GoogleMapsSpeedLimits.png",
            "category" : "Google Maps",
            "description" : "Interact with Google Maps Services",
            "keywords" : [
                                "google"
                ,"maps"
                ,"speedlimit"
                ,"places"

            ],
                "isaction" : "true",
                "actiontitle" : "Get speedlimits for places using Google Maps",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google maps api key"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/maps/premium/previous-licenses/clientside/auth",
            "parameters" : [
                                   {
                                       "name" : "PlaceIds",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Speedlimits",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-maps-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleMapsStaticMaps",
        "displayName" : "GoogleMapsStaticMaps",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.maps.StaticMapsWorkitemHandler(\"apiKey\")",
        "documentation" : "google-maps-workitem/index.html",
        "module" : "google-maps-workitem",
        "icon" : "GoogleMapsStaticMaps.png",
            "category" : "Google Maps",
            "description" : "Interact with Google Maps Services",
            "keywords" : [
                                "google"
                ,"maps"
                ,"directions"
                ,"locations"

            ],
                "isaction" : "true",
                "actiontitle" : "Get directions using Google Maps",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google maps api key"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/maps/premium/previous-licenses/clientside/auth",
            "parameters" : [
                                   {
                                       "name" : "Markers",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Zoom",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Height",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "CenterLocation",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Scale",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Width",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "MapType",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "StaticMap",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-maps-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleMapsGeocoding",
        "displayName" : "GoogleMapsGeocoding",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.maps.GeocodingWorkitemHandler(\"apiKey\")",
        "documentation" : "google-maps-workitem/index.html",
        "module" : "google-maps-workitem",
        "icon" : "GoogleMapsGeocoding.png",
            "category" : "Google Maps",
            "description" : "Interact with Google Maps Services",
            "keywords" : [
                                "google"
                ,"maps"
                ,"geocoding"
                ,"locations"

            ],
                "isaction" : "true",
                "actiontitle" : "Get geocoding information using Google Maps",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google maps api key"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/maps/premium/previous-licenses/clientside/auth",
            "parameters" : [
                                   {
                                       "name" : "SearchLocation",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Bounds",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SearchType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "LocationType",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "GeocodingResults",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-maps-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleMapsTimezone",
        "displayName" : "GoogleMapsTimezone",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.maps.TimezoneWorkitemHandler(\"apiKey\")",
        "documentation" : "google-maps-workitem/index.html",
        "module" : "google-maps-workitem",
        "icon" : "GoogleMapsTimezone.png",
            "category" : "Google Maps",
            "description" : "Interact with Google Maps Services",
            "keywords" : [
                                "google"
                ,"maps"
                ,"timezone"
                ,"locations"

            ],
                "isaction" : "true",
                "actiontitle" : "Get timezone information using Google Maps",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google maps api key"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/maps/premium/previous-licenses/clientside/auth",
            "parameters" : [
                                   {
                                       "name" : "LatLong",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "TimezonResults",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-maps-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleMapsDirections",
        "displayName" : "GoogleMapsDirections",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.maps.DirectionsWorkitemHandler(\"apiKey\")",
        "documentation" : "google-maps-workitem/index.html",
        "module" : "google-maps-workitem",
        "icon" : "GoogleMapsDirections.png",
            "category" : "Google Maps",
            "description" : "Interact with Google Maps Services",
            "keywords" : [
                                "google"
                ,"maps"
                ,"directions"
                ,"locations"

            ],
                "isaction" : "true",
                "actiontitle" : "Get directions using Google Maps",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google maps api key"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/maps/premium/previous-licenses/clientside/auth",
            "parameters" : [
                                   {
                                       "name" : "Origin",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Destination",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Mode",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Avoid",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Units",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Directions",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-maps-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleReadSheetValues",
        "displayName" : "GoogleReadSheetValues",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.sheets.ReadSheetValuesWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-sheets-workitem/index.html",
        "module" : "google-sheets-workitem",
        "icon" : "GoogleReadSheetValues.png",
            "category" : "Google Sheets",
            "description" : "Read content of sheets via Google",
            "keywords" : [
                                "google"
                ,"sheets"
                ,"read"

            ],
                "isaction" : "true",
                "actiontitle" : "Read spreadsheet using Google Sheets",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/sheets/api/guides/authorizing",
            "parameters" : [
                                   {
                                       "name" : "SheetId",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Range",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "SheetValues",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-sheets-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleAddTask",
        "displayName" : "GoogleAddTask",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.tasks.AddTaskWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-tasks-workitem/index.html",
        "module" : "google-tasks-workitem",
        "icon" : "GoogleAddTask.png",
            "category" : "Google Tasks",
            "description" : "Add and retrieve tasks via Google",
            "keywords" : [
                                "google"
                ,"tasks"
                ,"add"

            ],
                "isaction" : "true",
                "actiontitle" : "Add a new task using Google Tasks",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/tasks/auth",
            "parameters" : [
                                   {
                                       "name" : "TaskName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "TaskKind",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-tasks-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleGetTasks",
        "displayName" : "GoogleGetTasks",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.tasks.GetTasksWorkitemHandler(\"appName\", \"clentSecret\")",
        "documentation" : "google-tasks-workitem/index.html",
        "module" : "google-tasks-workitem",
        "icon" : "GoogleGetTasks.png",
            "category" : "Google Tasks",
            "description" : "Add and retrieve tasks via Google",
            "keywords" : [
                                "google"
                ,"tasks"
                ,"get"

            ],
                "isaction" : "true",
                "actiontitle" : "Get an existing task using Google Tasks",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google app name"
                                           }
                    ,{
                                               "name" : "Google client secret"
                                           }

                ],
                "authreferencesite" : "https://developers.google.com/tasks/auth",
            "parameters" : [
                                   {
                                       "name" : "NumOfTasks",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "FoundTasks",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-tasks-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GoogleDetectLanguage",
        "displayName" : "GoogleDetectLanguage",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.translate.DetectLanguageWorkitemHandler(\"apiKey\")",
        "documentation" : "google-translate-workitem/index.html",
        "module" : "google-translate-workitem",
        "icon" : "GoogleDetectLanguage.png",
            "category" : "Google Translate",
            "description" : "Translate text from/to different languages, or detect text language",
            "keywords" : [
                                "google"
                ,"translate"
                ,"detect"
                ,"language"

            ],
                "isaction" : "true",
                "actiontitle" : "Detect the language of provided text",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google cloud api key"
                                           }

                ],
                "authreferencesite" : "https://cloud.google.com/translate/docs/quickstart",
            "parameters" : [
                                   {
                                       "name" : "ToDetectText",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "DetectedLanguage",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-translate-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GoogleTranslate",
        "displayName" : "GoogleTranslate",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.google.translate.TranslateWorkitemHandler(\"apiKey\")",
        "documentation" : "google-translate-workitem/index.html",
        "module" : "google-translate-workitem",
        "icon" : "GoogleTranslate.png",
            "category" : "Google Translate",
            "description" : "Translate text from/to different languages, or detect text language",
            "keywords" : [
                                "google"
                ,"translate"
                ,"language"

            ],
                "isaction" : "true",
                "actiontitle" : "Translate text to a different language",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Google cloud api key"
                                           }

                ],
                "authreferencesite" : "https://cloud.google.com/translate/docs/quickstart",
            "parameters" : [
                                   {
                                       "name" : "TargetLang",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ToTranslate",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SourceLang",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Translation",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "google-translate-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "IBMWatsonClassifyImage",
        "displayName" : "IBMWatsonClassifyImage",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ibm.watson.ClassifyImageWorkitemHandler(\"apiKey\")",
        "documentation" : "ibm-watson-workitem/index.html",
        "module" : "ibm-watson-workitem",
        "icon" : "IBMWatsonClassifyImage.png",
            "category" : "IBM Watson",
            "description" : "Classify image and detect faces in image via IBM Watson",
            "keywords" : [
                                "ibm"
                ,"watson"
                ,"image"
                ,"classify"

            ],
                "isaction" : "true",
                "actiontitle" : "Classify an image using IBM Watson",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "IBM Watson api key"
                                           }

                ],
                "authreferencesite" : "https://www.ibm.com/watson/developercloud/doc/virtual-agent/api-keys.html",
            "parameters" : [
                                   {
                                       "name" : "ImageToClassify",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Classification",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ibm-watson-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "IBMWatsonDetectFaces",
        "displayName" : "IBMWatsonDetectFaces",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ibm.watson.DetectFacesWorkitemHandler(\"apiKey\")",
        "documentation" : "ibm-watson-workitem/index.html",
        "module" : "ibm-watson-workitem",
        "icon" : "IBMWatsonDetectFaces.png",
            "category" : "IBM Watson",
            "description" : "Classify image and detect faces in image via IBM Watson",
            "keywords" : [
                                "ibm"
                ,"watson"
                ,"image"
                ,"detect"
                ,"face"
                ,"faces"

            ],
                "isaction" : "true",
                "actiontitle" : "Detect faces in an image using IBM Watson",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "IBM Watson api key"
                                           }

                ],
                "authreferencesite" : "https://www.ibm.com/watson/developercloud/doc/virtual-agent/api-keys.html",
            "parameters" : [
                                   {
                                       "name" : "ImageToDetect",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Detection",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ibm-watson-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "IFTTTCall",
        "displayName" : "IFTTTCall",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.ifttt.IFTTTWorkitemHandler(\"key\")",
        "documentation" : "ifttt-workitem/index.html",
        "module" : "ifttt-workitem",
        "icon" : "IFTTTCall.png",
            "category" : "IFTTT",
            "description" : "Send a trigger message via IFTTT",
            "keywords" : [
                                "ifttt"
                ,"trigger"
                ,"endpoint"

            ],
                "isaction" : "true",
                "actiontitle" : "Trigger an IFTTT endpoint",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "IFTTT app key"
                                           }

                ],
                "authreferencesite" : "https://platform.ifttt.com/docs/api_reference",
            "parameters" : [
                                   {
                                       "name" : "Trigger",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Value3",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Value1",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Value2",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "ifttt-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Jabber",
        "displayName" : "Jabber",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jabber.JabberWorkItemHandler()",
        "documentation" : "jabber-workitem/index.html",
        "module" : "jabber-workitem",
        "icon" : "Jabber.png",
            "category" : "Jabber",
            "description" : "Send message via Jabber",
            "keywords" : [
                                "jabber"
                ,"im"
                ,"xmpp"
                ,"message"
                ,"send"

            ],
                "isaction" : "true",
                "actiontitle" : "Send a message using Jabber",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Jabber user"
                                           }
                    ,{
                                               "name" : "Jabber password"
                                           }

                ],
                "authreferencesite" : "https://www.jabber.org/",
            "parameters" : [
                                   {
                                       "name" : "User",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Server",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Port",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Service",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Text",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "To",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Password",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "jabber-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Java",
        "displayName" : "Java",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.java.JavaHandlerWorkItemHandler(\"ksession\")",
        "documentation" : "java-workitem/index.html",
        "module" : "java-workitem",
        "icon" : "Java.png",
            "category" : "Java",
            "description" : "Execute Java class",
            "keywords" : [
                                "java"
                ,"handler"
                ,"class"
                ,"execute"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute an existing Java Workitem Handler",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "Class",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "java-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "JavaInvocation",
        "displayName" : "JavaInvocation",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.java.JavaInvocationWorkItemHandler()",
        "documentation" : "java-workitem/index.html",
        "module" : "java-workitem",
        "icon" : "JavaInvocation.png",
            "category" : "Java",
            "description" : "Execute Java class",
            "keywords" : [
                                "java"
                ,"class"
                ,"execute"
                ,"invoke"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute a method on a Java class",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "Parameters",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Class",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Object",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Method",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ParameterTypes",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "java-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "DecisionTask",
        "displayName" : "Decision Task",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.bpmn2.DecisionTaskHandler()",
        "documentation" : "jbpm-workitems-bpmn2/index.html",
        "module" : "jbpm-workitems-bpmn2",
        "icon" : "DecisionTask.png",
            "category" : "BPMN2",
            "description" : "Execute business rule or service tasks",
            "keywords" : [
                                "decision"
                ,"dmn"
                ,"rule"
                ,"task"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute a DMN decision task",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Group Id"
                                           }
                    ,{
                                               "name" : "Artifact Id"
                                           }
                    ,{
                                               "name" : "Version"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "Model",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Namespace",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Decision",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-bpmn2",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "ServiceTask",
        "displayName" : "ServiceTask",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.bpmn2.ServiceTaskHandler()",
        "documentation" : "jbpm-workitems-bpmn2/index.html",
        "module" : "jbpm-workitems-bpmn2",
        "icon" : "ServiceTask.png",
            "category" : "BPMN2",
            "description" : "Execute business rule or service tasks",
            "keywords" : [
                                "service"
                ,"task"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute a service task",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "mode",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "interfaceImplementationRef",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "operationImplementationRef",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "implementation",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Parameter",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-bpmn2",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "BusinessRuleTask",
        "displayName" : "BusinessRuleTask",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.bpmn2.BusinessRuleTaskHandler()",
        "documentation" : "jbpm-workitems-bpmn2/index.html",
        "module" : "jbpm-workitems-bpmn2",
        "icon" : "BusinessRuleTask.png",
            "category" : "BPMN2",
            "description" : "Execute business rule or service tasks",
            "keywords" : [
                                "business"
                ,"rule"
                ,"task"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute a business rule task",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Group Id"
                                           }
                    ,{
                                               "name" : "Artifact Id"
                                           }
                    ,{
                                               "name" : "Version"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "KieSessionName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "KieSessionType",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-bpmn2",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Email",
        "displayName" : "Email",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.email.EmailWorkItemHandler()",
        "documentation" : "jbpm-workitems-email/index.html",
        "module" : "jbpm-workitems-email",
        "icon" : "Email.png",
            "category" : "Email",
            "description" : "Send an email",
            "keywords" : [
                                "send"
                ,"email"

            ],
                "isaction" : "true",
                "actiontitle" : "Send email",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Host"
                                           }
                    ,{
                                               "name" : "Port"
                                           }
                    ,{
                                               "name" : "User Name"
                                           }
                    ,{
                                               "name" : "Password"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "Reply-To",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Cc",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Bcc",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "From",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "To",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Body",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Attachments",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Subject",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Debug",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Template",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-email",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "JMSSendTask",
        "displayName" : "JMSSendTask",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jms.JMSSendTaskWorkItemHandler()",
        "documentation" : "jbpm-workitems-jms/index.html",
        "module" : "jbpm-workitems-jms",
        "icon" : "JMSSendTask.png",
            "category" : "JMS",
            "description" : "Send JSM messages",
            "keywords" : [
                                "jsm"
                ,"send"
                ,"task"

            ],
                "isaction" : "true",
                "actiontitle" : "Send JMS Message",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Connection Factory JNDI Name"
                                           }
                    ,{
                                               "name" : "Destination JNDI Name"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "Signal",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SignalWorkItemId",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SignalProcessInstanceId",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SignalDeploymentId",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Data",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-jms",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Rest",
        "displayName" : "Rest",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.rest.RESTWorkItemHandler()",
        "documentation" : "jbpm-workitems-rest/index.html",
        "module" : "jbpm-workitems-rest",
        "icon" : "Rest.png",
            "category" : "REST",
            "description" : "Perform REST calls",
            "keywords" : [
                                "rest"
                ,"call"

            ],
                "isaction" : "true",
                "actiontitle" : "Perform a Rest call",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "User Name"
                                           }
                    ,{
                                               "name" : "Password"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "ConnectTimeout",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ResultClass",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContentType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "AcceptCharset",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Headers",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "AuthUrl",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Method",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ReadTimeout",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Url",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContentTypeCharset",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "HandleResponseErrors",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ContentData",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Username",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Content",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "AcceptHeader",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "AuthType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Password",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-rest",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "WebService",
        "displayName" : "WebService",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler()",
        "documentation" : "jbpm-workitems-webservice/index.html",
        "module" : "jbpm-workitems-webservice",
        "icon" : "WebService.png",
            "category" : "WebService",
            "description" : "Perform WebService operations",
            "keywords" : [
                                "webservice"
                ,"call"

            ],
                "isaction" : "true",
                "actiontitle" : "Perform a WebService call",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "Endpoint",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Mode",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Parameter",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Operation",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Url",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Namespace",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Interface",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm",
                                       "artifactId" : "jbpm-workitems-webservice",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "JiraResolveIssue",
        "displayName" : "JiraResolveIssue",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jira.ResolveIssueWorkitemHandler(\"userName\", \"password\", \"repoURI\")",
        "documentation" : "jira-workitem/index.html",
        "module" : "jira-workitem",
        "icon" : "JiraResolveIssue.png",
            "category" : "Jira",
            "description" : "Create or update Jiras",
            "keywords" : [
                                "jira"
                ,"issue"
                ,"resolve"

            ],
                "isaction" : "true",
                "actiontitle" : "Resolve existing Jira issue",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Jira user"
                                           }
                    ,{
                                               "name" : "Jira password"
                                           }
                    ,{
                                               "name" : "Repository URI"
                                           }

                ],
                "authreferencesite" : "https://www.atlassian.com/software/jira",
            "parameters" : [
                                   {
                                       "name" : "ResolutionComment",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "IssueKey",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Resolution",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "jira-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "JiraCreateIssue",
        "displayName" : "JiraCreateIssue",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jira.CreateIssueWorkitemHandler(\"userName\", \"password\", \"repoURI\")",
        "documentation" : "jira-workitem/index.html",
        "module" : "jira-workitem",
        "icon" : "JiraCreateIssue.png",
            "category" : "Jira",
            "description" : "Create or update Jiras",
            "keywords" : [
                                "jira"
                ,"issue"
                ,"create"

            ],
                "isaction" : "true",
                "actiontitle" : "Create a new Jira issue",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Jira user"
                                           }
                    ,{
                                               "name" : "Jira password"
                                           }
                    ,{
                                               "name" : "Repository URI"
                                           }

                ],
                "authreferencesite" : "https://www.atlassian.com/software/jira",
            "parameters" : [
                                   {
                                       "name" : "ProjectKey",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "AssigneeName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ReporterName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "IssueDescription",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "IssueSummary",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "IssueType",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ComponentName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "CreatedIssueKey",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "jira-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "JiraAddComment",
        "displayName" : "JiraAddComment",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jira.AddCommentOnIssueWorkitemHandler(\"userName\", \"password\", \"repoURI\")",
        "documentation" : "jira-workitem/index.html",
        "module" : "jira-workitem",
        "icon" : "JiraAddComment.png",
            "category" : "Jira",
            "description" : "Create or update Jiras",
            "keywords" : [
                                "jira"
                ,"issue"
                ,"add"
                ,"comment"

            ],
                "isaction" : "true",
                "actiontitle" : "Add comment to an existing Jira issue",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Jira user"
                                           }
                    ,{
                                               "name" : "Jira password"
                                           }
                    ,{
                                               "name" : "Repository URI"
                                           }

                ],
                "authreferencesite" : "https://www.atlassian.com/software/jira",
            "parameters" : [
                                   {
                                       "name" : "Comment",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "IssueKey",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Commenter",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "CommentVisibleTo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "jira-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "JiraJqlSearch",
        "displayName" : "JiraJqlSearch",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jira.JqlSearchWorkitemHandler(\"userName\", \"password\", \"repoURI\")",
        "documentation" : "jira-workitem/index.html",
        "module" : "jira-workitem",
        "icon" : "JiraJqlSearch.png",
            "category" : "Jira",
            "description" : "Create or update Jiras",
            "keywords" : [
                                "jira"
                ,"jql"
                ,"search"
                ,"query"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute a Jql query",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Jira user"
                                           }
                    ,{
                                               "name" : "Jira password"
                                           }
                    ,{
                                               "name" : "Repository URI"
                                           }

                ],
                "authreferencesite" : "https://www.atlassian.com/software/jira",
            "parameters" : [
                                   {
                                       "name" : "SearchQuery",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "SearchResults",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "jira-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "JPA",
        "displayName" : "JPA",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.jpa.JPAWorkItemHandler(\"persistenceUnit\", \"classloader\")",
        "documentation" : "jpa-workitem/index.html",
        "module" : "jpa-workitem",
        "icon" : "JPA.png",
            "category" : "JPA",
            "description" : "Perform JPA operation",
            "keywords" : [
                                "jpa"
                ,"query"
                ,"named"
                ,"entity"

            ],
                "isaction" : "true",
                "actiontitle" : "Perform a JPA operation",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Persistence Unit name"
                                           }

                ],
                "authreferencesite" : "",
            "parameters" : [
                                   {
                                       "name" : "Entity",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Type",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Action",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Query",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Id",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "QueryParameters",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "QueryResults",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "jpa-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "KafkaPublishMessages",
        "displayName" : "KafkaPublishMessages",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.kafka.KafkaWorkItemHandler(\"bootstrapServers\", \"clientId\", \"keySerializerClass\", \"valueSerializerClass\")",
        "documentation" : "kafka-workitem/index.html",
        "module" : "kafka-workitem",
        "icon" : "KafkaPublishMessages.png",
            "category" : "Kafka",
            "description" : "publish kafka messages from a process",
            "keywords" : [
                                "kafka"
                ,"publish"
                ,"message"
                ,"topic"

            ],
                "isaction" : "true",
                "actiontitle" : "Publish message to a kafka topic",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Bootstrap Servers"
                                           }
                    ,{
                                               "name" : "Client ID"
                                           }
                    ,{
                                               "name" : "Key Serializer class"
                                           }
                    ,{
                                               "name" : "Value Serializer class"
                                           }

                ],
                "authreferencesite" : "https://kafka.apache.org/10/javadoc/org/apache/kafka/clients/producer/KafkaProducer.html",
            "parameters" : [
                                   {
                                       "name" : "Value",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Topic",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Key",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "kafka-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "MavenEmbedder",
        "displayName" : "MavenEmbedder",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.mavenembedder.MavenEmbedderWorkItemHandler()",
        "documentation" : "mavenembedder-workitem/index.html",
        "module" : "mavenembedder-workitem",
        "icon" : "MavenEmbedder.png",
            "category" : "Maven Embedder",
            "description" : "Execute Maven builds",
            "keywords" : [
                                "maven"
                ,"mvn"
                ,"build"
                ,"execute"
                ,"pom"
                ,"project"
                ,"intall"

            ],
                "isaction" : "true",
                "actiontitle" : "Execute Maven commands",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "CLOptions",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "WorkDirectory",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Mode",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ProjectRoot",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Goals",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "MavenResults",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "mavenembedder-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "OktaCreateGroup",
        "displayName" : "OktaCreateGroup",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.okta.CreateGroupWorkitemHandler(\"apiToken\")",
        "documentation" : "okta-workitem/index.html",
        "module" : "okta-workitem",
        "icon" : "OktaCreateGroup.png",
            "category" : "Okta",
            "description" : "Interact with Okta management API",
            "keywords" : [
                                "okta"
                ,"auth"
                ,"group"
                ,"create"

            ],
                "isaction" : "true",
                "actiontitle" : "Create new group to Okta",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Okta api token"
                                           }

                ],
                "authreferencesite" : "https://developer.okta.com/",
            "parameters" : [
                                   {
                                       "name" : "GroupName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "GroupDescription",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "GroupId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "okta-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "OktaGetUsers",
        "displayName" : "OktaGetUsers",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.okta.GetUsersWorkitemHandler(\"apiToken\")",
        "documentation" : "okta-workitem/index.html",
        "module" : "okta-workitem",
        "icon" : "OktaGetUsers.png",
            "category" : "Okta",
            "description" : "Interact with Okta management API",
            "keywords" : [
                                "okta"
                ,"auth"
                ,"users"
                ,"get"

            ],
                "isaction" : "true",
                "actiontitle" : "Get users from Okta",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Okta api token"
                                           }

                ],
                "authreferencesite" : "https://developer.okta.com/",
            "parameters" : [
                                   {
                                       "name" : "UserIds",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Users",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "okta-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "OktaAddUserToGroup",
        "displayName" : "OktaAddUserToGroup",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.okta.AddUserToGroupWorkitemHandler(\"apiToken\")",
        "documentation" : "okta-workitem/index.html",
        "module" : "okta-workitem",
        "icon" : "OktaAddUserToGroup.png",
            "category" : "Okta",
            "description" : "Interact with Okta management API",
            "keywords" : [
                                "okta"
                ,"auth"
                ,"user"
                ,"add"
                ,"group"

            ],
                "isaction" : "true",
                "actiontitle" : "Add user to group in Okta",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Okta api token"
                                           }

                ],
                "authreferencesite" : "https://developer.okta.com/",
            "parameters" : [
                                   {
                                       "name" : "UserId",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "GroupId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "okta-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "OktaGetApplications",
        "displayName" : "OktaGetApplications",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.okta.GetApplicationsWorkitemHandler(\"apiToken\")",
        "documentation" : "okta-workitem/index.html",
        "module" : "okta-workitem",
        "icon" : "OktaGetApplications.png",
            "category" : "Okta",
            "description" : "Interact with Okta management API",
            "keywords" : [
                                "okta"
                ,"auth"
                ,"application"
                ,"get"

            ],
                "isaction" : "true",
                "actiontitle" : "Get applications from Okta",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Okta api token"
                                           }

                ],
                "authreferencesite" : "https://developer.okta.com/",
            "parameters" : [
                                   {
                                       "name" : "AppIds",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Applications",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "okta-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "OktaCreateUser",
        "displayName" : "OktaCreateUser",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.okta.CreateUserWorkitemHandler(\"apiToken\")",
        "documentation" : "okta-workitem/index.html",
        "module" : "okta-workitem",
        "icon" : "OktaCreateUser.png",
            "category" : "Okta",
            "description" : "Interact with Okta management API",
            "keywords" : [
                                "okta"
                ,"auth"
                ,"user"
                ,"create"

            ],
                "isaction" : "true",
                "actiontitle" : "Create new user to Okta",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Okta api token"
                                           }

                ],
                "authreferencesite" : "https://developer.okta.com/",
            "parameters" : [
                                   {
                                       "name" : "UserActive",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserSecurityQuestion",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserGroupIds",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserLastName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserPassword",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserFirstName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserSecurityAnswer",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserEmail",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "UserLogin",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "UserId",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "okta-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "DailyForecast",
        "displayName" : "DailyForecast",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.owm.DailyForecastWorkitemHandler(\"apiKey\")",
        "documentation" : "openweathermap-workitem/index.html",
        "module" : "openweathermap-workitem",
        "icon" : "DailyForecast.png",
            "category" : "Weather Info",
            "description" : "Retrieve weather info using OpenWeatherMap",
            "keywords" : [
                                "openweathermap"
                ,"weather"
                ,"daily"
                ,"forecase"

            ],
                "isaction" : "true",
                "actiontitle" : "Get the weather daily forecast for a location",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "OpenWeatherMap api key"
                                           }

                ],
                "authreferencesite" : "https://openweathermap.org/appid",
            "parameters" : [
                                   {
                                       "name" : "CityName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "CountryCode",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "DailyForecastData",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "openweathermap-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "CurrentWeather",
        "displayName" : "CurrentWeather",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.owm.CurrentWeatherWorkitemHandler(\"apiKey\")",
        "documentation" : "openweathermap-workitem/index.html",
        "module" : "openweathermap-workitem",
        "icon" : "CurrentWeather.png",
            "category" : "Weather Info",
            "description" : "Retrieve weather info using OpenWeatherMap",
            "keywords" : [
                                "openweathermap"
                ,"weather"
                ,"current"

            ],
                "isaction" : "true",
                "actiontitle" : "Get current weather information for a location",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "OpenWeatherMap api key"
                                           }

                ],
                "authreferencesite" : "https://openweathermap.org/appid",
            "parameters" : [
                                   {
                                       "name" : "CityName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "CountryCode",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "CurrentWeatherData",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "openweathermap-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Parser",
        "displayName" : "Parser",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.parser.ParserWorkItemHandler()",
        "documentation" : "parser-workitem/index.html",
        "module" : "parser-workitem",
        "icon" : "Parser.png",
            "category" : "Parser",
            "description" : "Parse Strings to objects and vice-versa",
            "keywords" : [
                                "parse"
                ,"java"
                ,"object"
                ,"string"
                ,"xml"
                ,"json"

            ],
                "isaction" : "true",
                "actiontitle" : "Parse Java object to string and vice-versa",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "Type",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Input",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Format",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "Result",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "parser-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "CreatePastebin",
        "displayName" : "CreatePastebin",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.pastebin.CreatePastebinWorkitemHandler(\"develKey\")",
        "documentation" : "pastebin-workitem/index.html",
        "module" : "pastebin-workitem",
        "icon" : "CreatePastebin.png",
            "category" : "Pastebin",
            "description" : "Create new or get existing pastes from Pastebin",
            "keywords" : [
                                "paste"
                ,"pastebin"
                ,"create"

            ],
                "isaction" : "true",
                "actiontitle" : "Create a paste on Pastebin",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Pastebin developer key"
                                           }

                ],
                "authreferencesite" : "https://pastebin.com/api.php",
            "parameters" : [
                                   {
                                       "name" : "Format",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Content",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Title",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Author",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Visibility",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "PasteURL",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "pastebin-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GetPastebin",
        "displayName" : "GetPastebin",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.pastebin.GetExistingPastebinWorkitemHandler(\"develKey\")",
        "documentation" : "pastebin-workitem/index.html",
        "module" : "pastebin-workitem",
        "icon" : "GetPastebin.png",
            "category" : "Pastebin",
            "description" : "Create new or get existing pastes from Pastebin",
            "keywords" : [
                                "paste"
                ,"pastebin"
                ,"get"
                ,"existing"

            ],
                "isaction" : "true",
                "actiontitle" : "Get an existing Pastebin",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Pastebin developer key"
                                           }

                ],
                "authreferencesite" : "https://pastebin.com/api.php",
            "parameters" : [
                                   {
                                       "name" : "PastebinKey",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "PasteContent",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "pastebin-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "GeneratePDF",
        "displayName" : "GeneratePDF",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.pdf.GeneratePDFWorkitemHandler()",
        "documentation" : "pdf-workitem/index.html",
        "module" : "pdf-workitem",
        "icon" : "GeneratePDF.png",
            "category" : "PDF",
            "description" : "Create PDF from xhtml template using freemarker",
            "keywords" : [
                                "pdf"
                ,"generate"
                ,"template"
                ,"document"
                ,"freemarker"
                ,"xhtml"

            ],
                "isaction" : "true",
                "actiontitle" : "Generate PDF document",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "TemplateXHTML",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "PDFName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "PDFDocument",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "pdf-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "RiotSummonerInfo",
        "displayName" : "RiotSummonerInfo",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.riot.SummonerInfoWorkitemHandler(\"apiKey\")",
        "documentation" : "riot-workitem/index.html",
        "module" : "riot-workitem",
        "icon" : "RiotSummonerInfo.png",
            "category" : "Riot Games",
            "description" : "Gather and use League of Legends data",
            "keywords" : [
                                "riot"
                ,"league"
                ,"legends"
                ,"summoner"
                ,"get"
                ,"info"

            ],
                "isaction" : "true",
                "actiontitle" : "Get Summoner info",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Riot Games api key"
                                           }

                ],
                "authreferencesite" : "https://developer.riotgames.com/api-keys.html",
            "parameters" : [
                                   {
                                       "name" : "SummonerPlatform",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SummonerName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "SummonerInfo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "riot-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "RiotSummonerLastMatch",
        "displayName" : "RiotSummonerLastMatch",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.riot.LastSummonerMatchWorkitemHandler(\"apiKey\")",
        "documentation" : "riot-workitem/index.html",
        "module" : "riot-workitem",
        "icon" : "RiotSummonerLastMatch.png",
            "category" : "Riot Games",
            "description" : "Gather and use League of Legends data",
            "keywords" : [
                                "riot"
                ,"league"
                ,"legends"
                ,"summoner"
                ,"match"
                ,"get"
                ,"info"

            ],
                "isaction" : "true",
                "actiontitle" : "Get Summoner last match info",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Riot Games api key"
                                           }

                ],
                "authreferencesite" : "https://developer.riotgames.com/api-keys.html",
            "parameters" : [
                                   {
                                       "name" : "SummonerPlatform",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SummonerName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "LastMatch",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "riot-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "RiotMatchInfo",
        "displayName" : "RiotMatchInfo",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.riot.MatchesInfoWorkitemHandler(\"apiKey\")",
        "documentation" : "riot-workitem/index.html",
        "module" : "riot-workitem",
        "icon" : "RiotMatchInfo.png",
            "category" : "Riot Games",
            "description" : "Gather and use League of Legends data",
            "keywords" : [
                                "riot"
                ,"league"
                ,"legends"
                ,"summoner"
                ,"match"
                ,"get"
                ,"info"

            ],
                "isaction" : "true",
                "actiontitle" : "Get Match Info",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Riot Games api key"
                                           }

                ],
                "authreferencesite" : "https://developer.riotgames.com/api-keys.html",
            "parameters" : [
                                   {
                                       "name" : "SummonerPlatform",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "SummonerName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "NumOfMatches",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "MatchesInfo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "riot-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "RSS",
        "displayName" : "RSS",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.rss.RSSWorkItemHandler()",
        "documentation" : "rss-workitem/index.html",
        "module" : "rss-workitem",
        "icon" : "RSS.png",
            "category" : "RSS",
            "description" : "Create RSS feeds",
            "keywords" : [
                                "rss"
                ,"feed"
                ,"create"

            ],
                "isaction" : "true",
                "actiontitle" : "Create a RSS feed from multiple sources",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "URL",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "rss-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "SlackPostMessageToChannel",
        "displayName" : "SlackPostMessageToChannel",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.slack.PostMessageToChannelWorkitemHandler(\"accessToken\")",
        "documentation" : "slack-workitem/index.html",
        "module" : "slack-workitem",
        "icon" : "SlackPostMessageToChannel.png",
            "category" : "Slack",
            "description" : "Post messages and add reminders using Slack",
            "keywords" : [
                                "slack"
                ,"message"
                ,"send"
                ,"channel"

            ],
                "isaction" : "true",
                "actiontitle" : "Send message to a Slack channel",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Slack access token"
                                           }

                ],
                "authreferencesite" : "https://api.slack.com/tokens",
            "parameters" : [
                                   {
                                       "name" : "ChannelName",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Message",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "slack-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "SlackAddReminder",
        "displayName" : "SlackAddReminder",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.slack.AddReminderWorkitemHandler(\"accessToken\")",
        "documentation" : "slack-workitem/index.html",
        "module" : "slack-workitem",
        "icon" : "SlackAddReminder.png",
            "category" : "Slack",
            "description" : "Post messages and add reminders using Slack",
            "keywords" : [
                                "slack"
                ,"reminder"
                ,"remind"
                ,"send"
                ,"message"

            ],
                "isaction" : "true",
                "actiontitle" : "Add a reminder to Slack",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Slack access token"
                                           }

                ],
                "authreferencesite" : "https://api.slack.com/tokens",
            "parameters" : [
                                   {
                                       "name" : "ReminderText",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ReminderTime",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "slack-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "Transform",
        "displayName" : "Transform",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.transform.TransformWorkItemHandler()",
        "documentation" : "transform-workitem/index.html",
        "module" : "transform-workitem",
        "icon" : "Transform.png",
            "category" : "Transform",
            "description" : "Transform Java input objects to output objects",
            "keywords" : [
                                "transform"
                ,"input"
                ,"output"

            ],
                "isaction" : "true",
                "actiontitle" : "Transforma a Java input Object to an output Object",
            "requiresauth" : "false",
            "parameters" : [
                                   {
                                       "name" : "InputObject",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "OutputType",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "OutputObject",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "transform-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "TwitterSendDirectMessage",
        "displayName" : "TwitterSendDirectMessage",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.twitter.SendDirectMessageWorkitemHandler(\"consumerKey\", \"consumerSecret\", \"accessKey\", \"accessSecret\")",
        "documentation" : "twitter-workitem/index.html",
        "module" : "twitter-workitem",
        "icon" : "TwitterSendDirectMessage.png",
            "category" : "Twitter",
            "description" : "Update status and send messages using Twitter",
            "keywords" : [
                                "twitter"
                ,"tweet"
                ,"send"
                ,"message"
                ,"direct"

            ],
                "isaction" : "true",
                "actiontitle" : "Send a direct twitter message",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Twitter consumer key"
                                           }
                    ,{
                                               "name" : "Twitter consumer secret"
                                           }
                    ,{
                                               "name" : "Twitter access key"
                                           }
                    ,{
                                               "name" : "Twitter access secret"
                                           }

                ],
                "authreferencesite" : "https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens.html",
            "parameters" : [
                                   {
                                       "name" : "DebugEnabled",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Message",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ScreenName",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "twitter-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "TwitterUpdateStatus",
        "displayName" : "TwitterUpdateStatus",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.twitter.UpdateStatusWorkitemHandler(\"consumerKey\", \"consumerSecret\", \"accessKey\", \"accessSecret\")",
        "documentation" : "twitter-workitem/index.html",
        "module" : "twitter-workitem",
        "icon" : "TwitterUpdateStatus.png",
            "category" : "Twitter",
            "description" : "Update status and send messages using Twitter",
            "keywords" : [
                                "twitter"
                ,"tweet"
                ,"update"
                ,"status"
                ,"message"

            ],
                "isaction" : "true",
                "actiontitle" : "Update your Twitter status",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Twitter consumer key"
                                           }
                    ,{
                                               "name" : "Twitter consumer secret"
                                           }
                    ,{
                                               "name" : "Twitter access key"
                                           }
                    ,{
                                               "name" : "Twitter access secret"
                                           }

                ],
                "authreferencesite" : "https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens.html",
            "parameters" : [
                                   {
                                       "name" : "StatusUpdate",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "DebugEnabled",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Media",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "twitter-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
{
        "name" : "UploadVimeo",
        "displayName" : "UploadVimeo",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.vimeo.UploadVideoWorkitemHandler(\"accessToken\")",
        "documentation" : "vimeo-workitem/index.html",
        "module" : "vimeo-workitem",
        "icon" : "UploadVimeo.png",
            "category" : "Vimeo",
            "description" : "Interact with videos on Vimeo",
            "keywords" : [
                                "vimeo"
                ,"video"
                ,"upload"
                ,"new"

            ],
                "isaction" : "true",
                "actiontitle" : "Upload new video on Vimeo",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Vimeo access token"
                                           }

                ],
                "authreferencesite" : "https://developer.vimeo.com/api/authentication",
            "parameters" : [
                                   {
                                       "name" : "VideoFile",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "VideoEndpoint",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "vimeo-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "DeleteVimeo",
        "displayName" : "DeleteVimeo",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.vimeo.DeleteVideoWorkitemHandler(\"accessToken\")",
        "documentation" : "vimeo-workitem/index.html",
        "module" : "vimeo-workitem",
        "icon" : "DeleteVimeo.png",
            "category" : "Vimeo",
            "description" : "Interact with videos on Vimeo",
            "keywords" : [
                                "vimeo"
                ,"video"
                ,"delete"

            ],
                "isaction" : "true",
                "actiontitle" : "Delete an existing video",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Vimeo access token"
                                           }

                ],
                "authreferencesite" : "https://developer.vimeo.com/api/authentication",
            "parameters" : [
                                   {
                                       "name" : "VideoEndpoint",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "ResponseStatusCode",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "vimeo-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "UpdateVimeo",
        "displayName" : "UpdateVimeo",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.vimeo.UpdateVideoMetadataWorkitemHandler(\"accessToken\")",
        "documentation" : "vimeo-workitem/index.html",
        "module" : "vimeo-workitem",
        "icon" : "UpdateVimeo.png",
            "category" : "Vimeo",
            "description" : "Interact with videos on Vimeo",
            "keywords" : [
                                "vimeo"
                ,"video"
                ,"update"
                ,"metadata"

            ],
                "isaction" : "true",
                "actiontitle" : "Update existing video metadata",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Vimeo access token"
                                           }

                ],
                "authreferencesite" : "https://developer.vimeo.com/api/authentication",
            "parameters" : [
                                   {
                                       "name" : "Description",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "License",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "PrivacyView",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "PrivacyEmbed",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "ReviewLink",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "VideoEndpoint",
                                       "type" : "new StringDataType()"
                                   }
                ,{
                                       "name" : "Name",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "ResponseStatusCode",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "vimeo-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}
,{
        "name" : "GetInfoVimeo",
        "displayName" : "GetInfoVimeo",
        "defaultHandler" : "mvel: new org.jbpm.process.workitem.vimeo.GetVideoInfoWorkitemHandler(\"accessToken\")",
        "documentation" : "vimeo-workitem/index.html",
        "module" : "vimeo-workitem",
        "icon" : "GetInfoVimeo.png",
            "category" : "Vimeo",
            "description" : "Interact with videos on Vimeo",
            "keywords" : [
                                "vimeo"
                ,"video"
                ,"get"
                ,"info"

            ],
                "isaction" : "true",
                "actiontitle" : "Get info for existing video",
            "requiresauth" : "true",
                "authparams" : [
                                           {
                                               "name" : "Vimeo access token"
                                           }

                ],
                "authreferencesite" : "https://developer.vimeo.com/api/authentication",
            "parameters" : [
                                   {
                                       "name" : "VideoEndpoint",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "results" : [
                                   {
                                       "name" : "VideoInfo",
                                       "type" : "new StringDataType()"
                                   }

            ],
            "mavenDependencies" : [
                                   {
                                       "groupId" : "org.jbpm.contrib",
                                       "artifactId" : "vimeo-workitem",
                                       "version" : "7.28.0.Final"
                                   }

            ]
}

,
]
