/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;

public class CommandRegistryImpl<C extends Command>
implements CommandRegistry<C> {
    private final Deque<C> commands = new ArrayDeque<C>();
    private int maxStackSize = 200;

    public void setMaxSize(int size) {
        this.maxStackSize = size;
    }

    public void register(C command) {
        this.addIntoStack(command);
    }

    public boolean remove(C command) {
        throw new UnsupportedOperationException("Remove not implemented yet.");
    }

    public void clear() {
        this.commands.clear();
    }

    public boolean contains(C item) {
        throw new UnsupportedOperationException("Contains not implemented yet.");
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public List<C> getCommandHistory() {
        return this.commands.stream().collect(Collectors.toList());
    }

    public C peek() {
        return (C)((Command)this.commands.peek());
    }

    public C pop() {
        return (C)((Command)this.commands.pop());
    }

    private void addIntoStack(C command) {
        if (null != command) {
            if (this.commands.size() + 1 > this.maxStackSize) {
                this.commands.removeLast();
            }
            this.commands.push(command);
        }
    }
}

