/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.engine;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.plugins.engine.PluginJarProcessor;
import org.uberfire.backend.server.plugins.engine.PluginWatcher;
import org.uberfire.util.URIUtil;

@Dependent
public class PluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(PluginManager.class);
    private PluginWatcher pluginWatcher;
    private PluginJarProcessor pluginJarProcessor;
    private ExecutorService executor;

    @Inject
    public PluginManager(PluginWatcher pluginWatcher, PluginJarProcessor pluginJarProcessor) {
        this.pluginWatcher = pluginWatcher;
        this.pluginJarProcessor = pluginJarProcessor;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    void shutDown() {
        this.pluginWatcher.stop();
    }

    public void init(String contextRootDir, String pluginDir) {
        try {
            this.pluginJarProcessor.init(pluginDir, this.findPluginDeploymentDir(contextRootDir));
            this.pluginWatcher.start(pluginDir, this.executor, this.pluginJarProcessor);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize " + PluginManager.class.getName(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    String findPluginDeploymentDir(String contextRootDir) throws IOException {
        Collection gwtFiles = FileUtils.listFiles((File)new File(this.encodePath(contextRootDir)), (String[])new String[]{"nocache.js"}, (boolean)true);
        if (!gwtFiles.isEmpty()) {
            File gwtFile = (File)gwtFiles.iterator().next();
            return gwtFile.getParentFile().getCanonicalPath();
        }
        return new File(contextRootDir).getCanonicalPath();
    }

    String encodePath(String contextRootDir) {
        return URIUtil.decode((String)contextRootDir);
    }
}

