/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.MVELSafeHelper;
import org.drools.scenariosimulation.backend.expression.BaseExpressionOperator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class MVELExpressionEvaluator
implements ExpressionEvaluator {
    private final ParserConfiguration config;
    private final MVELEvaluator evaluator = MVELSafeHelper.getEvaluator();
    private final ClassLoader classLoader;

    public MVELExpressionEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.config = new ParserConfiguration();
        this.config.setClassLoader(classLoader);
    }

    @Override
    public boolean evaluateUnaryExpression(Object rawExpression, Object resultValue, Class<?> resultClass) {
        if (!(rawExpression instanceof String)) {
            String rawClass = rawExpression == null ? null : rawExpression.getClass().getCanonicalName();
            throw new IllegalArgumentException("Raw expression should be a String and not a '" + rawClass + "'");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("actualValue", resultValue);
        Object expressionResult = this.compileAndExecute((String)rawExpression, params);
        if (!(expressionResult instanceof Boolean)) {
            return BaseExpressionOperator.EQUALS.eval(expressionResult, resultValue, resultClass, this.classLoader);
        }
        return (Boolean)expressionResult;
    }

    @Override
    public Object evaluateLiteralExpression(String className, List<String> genericClasses, Object rawExpression) {
        if (!(rawExpression instanceof String)) {
            throw new IllegalArgumentException("Raw expression should be a String and not a '" + rawExpression.getClass().getCanonicalName() + "'");
        }
        Object expressionResult = this.compileAndExecute((String)rawExpression, Collections.emptyMap());
        Class requiredClass = ScenarioBeanUtil.loadClass(className, this.classLoader);
        if (expressionResult != null && !requiredClass.isAssignableFrom(expressionResult.getClass())) {
            throw new IllegalArgumentException("Cannot assign a '" + expressionResult.getClass().getCanonicalName() + "' to '" + requiredClass.getCanonicalName());
        }
        return expressionResult;
    }

    @Override
    public String fromObjectToExpression(Object value) {
        throw new UnsupportedOperationException("The condition has not been satisfied");
    }

    protected Object compileAndExecute(String rawExpression, Map<String, Object> params) {
        ParserContext ctx = new ParserContext(this.config);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            ctx.addVariable(entry.getKey(), entry.getValue().getClass());
        }
        String expression = this.cleanExpression(rawExpression);
        Serializable compiledExpression = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        return this.evaluator.executeExpression((Object)compiledExpression, params);
    }

    protected String cleanExpression(String rawExpression) {
        if (!rawExpression.trim().startsWith("#")) {
            throw new IllegalArgumentException("Malformed MVEL expression '" + rawExpression + "'");
        }
        return rawExpression.replaceFirst("#", "");
    }
}

