/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.kie.api.runtime.KieContainer;

public abstract class AbstractRunnerHelper {
    public void run(KieContainer kieContainer, SimulationDescriptor simulationDescriptor, ScenarioWithIndex scenarioWithIndex, ExpressionEvaluatorFactory expressionEvaluatorFactory, ClassLoader classLoader, ScenarioRunnerData scenarioRunnerData) {
        Scenario scenario = scenarioWithIndex.getScenario();
        this.extractGivenValues(simulationDescriptor, scenario.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory).forEach(scenarioRunnerData::addGiven);
        this.extractExpectedValues(scenario.getUnmodifiableFactMappingValues()).forEach(scenarioRunnerData::addExpect);
        Map<String, Object> requestContext = this.executeScenario(kieContainer, scenarioRunnerData, expressionEvaluatorFactory, simulationDescriptor);
        scenarioRunnerData.setMetadata(this.extractResultMetadata(requestContext, scenarioWithIndex));
        this.verifyConditions(simulationDescriptor, scenarioRunnerData, expressionEvaluatorFactory, requestContext);
        this.validateAssertion(scenarioRunnerData.getResults(), scenario);
    }

    protected List<ScenarioGiven> extractGivenValues(SimulationDescriptor simulationDescriptor, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        ArrayList<ScenarioGiven> scenarioGiven = new ArrayList<ScenarioGiven>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = this.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.GIVEN);
        boolean hasError = false;
        for (Map.Entry<FactIdentifier, List<FactMappingValue>> entry : groupByFactIdentifier.entrySet()) {
            try {
                FactIdentifier factIdentifier = entry.getKey();
                Map<List<String>, Object> paramsForBean = this.getParamsForBean(simulationDescriptor, factIdentifier, entry.getValue(), expressionEvaluatorFactory);
                Object bean = this.getDirectMapping(paramsForBean).orElseGet(() -> this.createObject(factIdentifier.getClassName(), paramsForBean, classLoader));
                scenarioGiven.add(new ScenarioGiven(factIdentifier, bean));
            }
            catch (Exception e) {
                hasError = true;
            }
        }
        if (hasError) {
            throw new ScenarioException("Error in GIVEN data");
        }
        return scenarioGiven;
    }

    protected ResultWrapper<Object> getDirectMapping(Map<List<String>, Object> params) {
        for (Map.Entry<List<String>, Object> entry : params.entrySet()) {
            if (!entry.getKey().isEmpty()) continue;
            return ResultWrapper.createResult(entry.getValue());
        }
        return ResultWrapper.createErrorResultWithErrorMessage("No direct mapping available");
    }

    protected List<ScenarioExpect> extractExpectedValues(List<FactMappingValue> factMappingValues) {
        ArrayList<ScenarioExpect> scenarioExpect = new ArrayList<ScenarioExpect>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = this.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.EXPECT);
        Set inputFacts = factMappingValues.stream().filter(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())).map(FactMappingValue::getFactIdentifier).collect(Collectors.toSet());
        Iterator<Map.Entry<FactIdentifier, List<FactMappingValue>>> iterator = groupByFactIdentifier.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FactIdentifier, List<FactMappingValue>> entry;
            FactIdentifier factIdentifier;
            scenarioExpect.add(new ScenarioExpect(factIdentifier, entry.getValue(), !inputFacts.contains(factIdentifier = (entry = iterator.next()).getKey())));
        }
        return scenarioExpect;
    }

    protected Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifierAndFilter(List<FactMappingValue> factMappingValues, FactMappingType type) {
        HashMap<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = new HashMap<FactIdentifier, List<FactMappingValue>>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            FactIdentifier factIdentifier = factMappingValue.getFactIdentifier();
            if (factMappingValue.getRawValue() == null) continue;
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            if (expressionIdentifier == null) {
                throw new IllegalArgumentException("ExpressionIdentifier malformed");
            }
            if (!Objects.equals(expressionIdentifier.getType(), type)) continue;
            groupByFactIdentifier.computeIfAbsent(factIdentifier, key -> new ArrayList()).add(factMappingValue);
        }
        return groupByFactIdentifier;
    }

    protected Map<List<String>, Object> getParamsForBean(SimulationDescriptor simulationDescriptor, FactIdentifier factIdentifier, List<FactMappingValue> factMappingValues, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        HashMap<List<String>, Object> paramsForBean = new HashMap<List<String>, Object>();
        boolean hasError = false;
        for (FactMappingValue factMappingValue : factMappingValues) {
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List pathToField = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            ExpressionEvaluator expressionEvaluator = expressionEvaluatorFactory.getOrCreate(factMappingValue);
            try {
                Object value = expressionEvaluator.evaluateLiteralExpression(factMapping.getClassName(), factMapping.getGenericTypes(), factMappingValue.getRawValue());
                paramsForBean.put(pathToField, value);
            }
            catch (RuntimeException e) {
                factMappingValue.setExceptionMessage(e.getMessage());
                hasError = true;
            }
        }
        if (hasError) {
            throw new ScenarioException("Error in one or more input values");
        }
        return paramsForBean;
    }

    protected void validateAssertion(List<ScenarioResult> scenarioResults, Scenario scenario) {
        boolean scenarioFailed = false;
        for (ScenarioResult scenarioResult : scenarioResults) {
            if (scenarioResult.getResult()) continue;
            scenarioFailed = true;
            break;
        }
        if (scenarioFailed) {
            throw new ScenarioException("Scenario '" + scenario.getDescription() + "' failed");
        }
    }

    protected ScenarioResult fillResult(FactMappingValue expectedResult, Supplier<ResultWrapper<?>> resultSupplier, ExpressionEvaluator expressionEvaluator) {
        ResultWrapper<?> resultValue = resultSupplier.get();
        if (resultValue.isSatisfied()) {
            expectedResult.resetStatus();
        } else if (resultValue.getErrorMessage().isPresent()) {
            expectedResult.setExceptionMessage(resultValue.getErrorMessage().get());
        } else {
            try {
                expectedResult.setErrorValue((Object)expressionEvaluator.fromObjectToExpression(resultValue.getResult()));
            }
            catch (Exception e) {
                expectedResult.setExceptionMessage(e.getMessage());
            }
        }
        return new ScenarioResult(expectedResult, resultValue.getResult()).setResult(resultValue.isSatisfied());
    }

    protected ResultWrapper getResultWrapper(String className, FactMappingValue expectedResult, ExpressionEvaluator expressionEvaluator, Object expectedResultRaw, Object resultRaw, Class<?> resultClass) {
        try {
            boolean evaluationSucceed = expressionEvaluator.evaluateUnaryExpression(expectedResultRaw, resultRaw, resultClass);
            if (evaluationSucceed) {
                return ResultWrapper.createResult(resultRaw);
            }
            if (ScenarioSimulationSharedUtils.isCollection((String)className)) {
                return ResultWrapper.createErrorResultWithErrorMessage("Impossible to find elements in the collection to satisfy the conditions");
            }
            return ResultWrapper.createErrorResult(resultRaw, expectedResultRaw);
        }
        catch (Exception e) {
            expectedResult.setExceptionMessage(e.getMessage());
            return ResultWrapper.createErrorResultWithErrorMessage(e.getMessage());
        }
    }

    protected abstract ScenarioResultMetadata extractResultMetadata(Map<String, Object> var1, ScenarioWithIndex var2);

    protected abstract Map<String, Object> executeScenario(KieContainer var1, ScenarioRunnerData var2, ExpressionEvaluatorFactory var3, SimulationDescriptor var4);

    protected abstract void verifyConditions(SimulationDescriptor var1, ScenarioRunnerData var2, ExpressionEvaluatorFactory var3, Map<String, Object> var4);

    protected abstract Object createObject(String var1, Map<List<String>, Object> var2, ClassLoader var3);
}

