/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.workitem;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;

@Dependent
@Typed(value={WorkItemDefinitionCacheRegistry.class})
public class WorkItemDefinitionCacheRegistry
implements WorkItemDefinitionRegistry {
    private final Map<String, WorkItemDefinition> definitions = new HashMap<String, WorkItemDefinition>();

    @Override
    public Collection<WorkItemDefinition> items() {
        return this.definitions.values().stream().collect(Collectors.toList());
    }

    @Override
    public WorkItemDefinition get(String name) {
        return this.definitions.get(name);
    }

    public void register(WorkItemDefinition def) {
        this.definitions.put(def.getName(), def);
    }

    public WorkItemDefinition remove(String name) {
        return this.definitions.remove(name);
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    public void clear() {
        this.definitions.clear();
    }

    @PreDestroy
    public void destroy() {
        this.clear();
    }
}

