/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;

public class ScenarioSimulationSharedUtils {
    public static final String FILE_EXTENSION = "scesim";

    public static boolean isCollection(String className) {
        return ScenarioSimulationSharedUtils.isList(className) || ScenarioSimulationSharedUtils.isMap(className);
    }

    public static boolean isList(String className) {
        return List.class.getCanonicalName().equals(className) || ArrayList.class.getCanonicalName().equals(className) || LinkedList.class.getCanonicalName().equals(className);
    }

    public static boolean isMap(String className) {
        return Map.class.getCanonicalName().equals(className) || HashMap.class.getCanonicalName().equals(className);
    }

    public static List<ScenarioWithIndex> toScenarioWithIndex(Simulation simulation) {
        ArrayList<ScenarioWithIndex> toReturn = new ArrayList<ScenarioWithIndex>();
        List<Scenario> scenarios = simulation.getUnmodifiableScenarios();
        for (int index = 0; index < scenarios.size(); ++index) {
            toReturn.add(new ScenarioWithIndex(index + 1, scenarios.get(index)));
        }
        return toReturn;
    }
}

