/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.morph;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.clone.ClonePolicy;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;

public abstract class BindableMorphDefinition
implements MorphDefinition {
    protected abstract Class<?> getDefaultType();

    protected abstract Map<Class<?>, Collection<Class<?>>> getDomainMorphs();

    @Override
    public boolean accepts(String definitionId) {
        Set<Class<?>> s = this.getDomainMorphs().keySet();
        for (Class<?> c : s) {
            if (!this.getDefinitionId(c).equals(definitionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getBase() {
        Class<?> baseType = this.getDomainMorphs().keySet().iterator().next();
        return this.getDefinitionId(baseType);
    }

    @Override
    public ClonePolicy getPolicy() {
        return ClonePolicy.ALL;
    }

    public boolean canMorphType(Class<?> type) {
        return this.getDomainMorphs().keySet().contains(type);
    }

    @Override
    public String getDefault() {
        return this.getDefinitionId(this.getDefaultType());
    }

    @Override
    public Iterable<String> getTargets(String sourceId) {
        Class<?> sourceType = this.getSourceType(sourceId);
        if (null != sourceType) {
            return this.getTargetsForType(sourceType);
        }
        return null;
    }

    protected Class<?> getSourceType(String definitionId) {
        Set<Class<?>> s = this.getDomainMorphs().keySet();
        for (Class<?> c : s) {
            if (!this.getDefinitionId(c).equals(definitionId)) continue;
            return c;
        }
        return null;
    }

    protected Collection<String> getTargetsForType(Class<?> sourceType) {
        Collection<Class<?>> targetClasses = this.getDomainMorphs().get(sourceType);
        if (null != targetClasses && !targetClasses.isEmpty()) {
            LinkedList<String> result = new LinkedList<String>();
            for (Class<?> targetClass : targetClasses) {
                String id = this.getDefinitionId(targetClass);
                result.add(id);
            }
            return result;
        }
        return null;
    }

    protected Class<?> getTargetClass(Class<?> sourceType, String target) {
        Collection<Class<?>> targetClasses = this.getDomainMorphs().get(sourceType);
        if (null != targetClasses && !targetClasses.isEmpty()) {
            for (Class<?> targetClass : targetClasses) {
                String id = this.getDefinitionId(targetClass);
                if (!id.equals(target)) continue;
                return targetClass;
            }
        }
        return null;
    }

    protected String getDefinitionId(Class<?> definitionClass) {
        return BindableAdapterUtils.getDefinitionId(definitionClass);
    }
}

