/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorEditorService;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.services.backend.service.KieService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;

@Service
@ApplicationScoped
public class PersistenceDescriptorEditorServiceImpl
extends KieService<PersistenceDescriptorEditorContent>
implements PersistenceDescriptorEditorService {
    private final IOService ioService;
    private final RenameService renameService;
    private final PersistenceDescriptorService descriptorService;
    private final SaveAndRenameServiceImpl<PersistenceDescriptorEditorContent, Metadata> saveAndRenameService;

    @Inject
    public PersistenceDescriptorEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, PersistenceDescriptorService descriptorService, RenameService renameService, SaveAndRenameServiceImpl<PersistenceDescriptorEditorContent, Metadata> saveAndRenameService) {
        this.ioService = ioService;
        this.descriptorService = descriptorService;
        this.renameService = renameService;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public PersistenceDescriptorEditorContent loadContent(Path path, boolean createIfNotExists) {
        PersistenceDescriptorEditorContent content;
        if (createIfNotExists) {
            Pair<Path, Boolean> createIfNotExistsResult = this.createIfNotExists(path);
            content = (PersistenceDescriptorEditorContent)this.loadContent((Path)createIfNotExistsResult.getK1());
            content.setPath((Path)createIfNotExistsResult.getK1());
            content.setCreated(((Boolean)createIfNotExistsResult.getK2()).booleanValue());
        } else {
            content = (PersistenceDescriptorEditorContent)this.loadContent(path);
            content.setPath(path);
            content.setCreated(false);
        }
        return content;
    }

    protected PersistenceDescriptorEditorContent constructContent(Path path, Overview overview) {
        PersistenceDescriptorEditorContent content = new PersistenceDescriptorEditorContent();
        PersistenceDescriptorModel descriptorModel = (PersistenceDescriptorModel)this.descriptorService.load(path);
        content.setDescriptorModel(descriptorModel);
        content.setOverview(overview);
        content.setSource(this.ioService.readAllString(Paths.convert((Path)path)));
        return content;
    }

    public Path save(Path path, PersistenceDescriptorEditorContent content, Metadata metadata, String comment) {
        if (content != null && content.getDescriptorModel() != null) {
            this.descriptorService.save(path, (Object)content.getDescriptorModel(), (Object)metadata, comment);
        }
        return path;
    }

    public Pair<Path, Boolean> createIfNotExists(Path path) {
        if (this.ioService.notExists(Paths.convert((Path)path))) {
            PersistenceDescriptorModel descriptorModel = this.descriptorService.createModuleDefaultDescriptor(path);
            Path createdPath = this.descriptorService.save(path, (Object)descriptorModel, null, "Default persistence descriptor generated by system");
            return new Pair((Object)createdPath, (Object)true);
        }
        return new Pair((Object)Paths.normalizePath((Path)path), (Object)false);
    }

    public Path saveAndRename(Path path, String newFileName, Metadata metadata, PersistenceDescriptorEditorContent content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }

    public Path rename(Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }
}

