/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TextAnnotationPropertyReader;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class TextAnnotationPropertyReaderTest {
    private TextAnnotationPropertyReader tested;
    @Mock
    private TextAnnotation element;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private BPMNShape shape;
    private static final double RESOLUTION_FACTOR = 1.0;
    @Mock
    private ExtensionAttributeValue extensionAttributeValue;
    @Mock
    private FeatureMap valueMap;
    @Mock
    private MetaDataType metaDataType;

    @Before
    public void setUp() {
        PowerMockito.when((Object)this.element.getName()).thenReturn((Object)"name");
        PowerMockito.when((Object)this.element.getText()).thenReturn((Object)"text");
        PowerMockito.when((Object)this.element.getExtensionValues()).thenReturn(Arrays.asList(this.extensionAttributeValue));
        PowerMockito.when((Object)this.extensionAttributeValue.getValue()).thenReturn((Object)this.valueMap);
        PowerMockito.when((Object)this.valueMap.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true)).thenReturn(Arrays.asList(this.metaDataType));
        PowerMockito.when((Object)this.metaDataType.getName()).thenReturn((Object)CustomElement.name.name());
        PowerMockito.when((Object)this.metaDataType.getMetaValue()).thenReturn((Object)"custom");
        this.tested = new TextAnnotationPropertyReader(this.element, this.diagram, this.shape, 1.0);
    }

    @Test
    public void getExtendedName() {
        String name = this.tested.getName();
        Assert.assertEquals((Object)"custom", (Object)name);
    }

    @Test
    public void getName() {
        PowerMockito.when((Object)this.element.getExtensionValues()).thenReturn(Collections.emptyList());
        String name = this.tested.getName();
        Assert.assertEquals((Object)"name", (Object)name);
    }

    @Test
    public void getTextName() {
        PowerMockito.when((Object)this.element.getExtensionValues()).thenReturn(Collections.emptyList());
        PowerMockito.when((Object)this.element.getName()).thenReturn(null);
        String name = this.tested.getName();
        Assert.assertEquals((Object)"text", (Object)name);
    }

    @Test
    public void getNameNull() {
        PowerMockito.when((Object)this.element.getExtensionValues()).thenReturn(Collections.emptyList());
        PowerMockito.when((Object)this.element.getName()).thenReturn(null);
        PowerMockito.when((Object)this.element.getText()).thenReturn(null);
        String name = this.tested.getName();
        Assert.assertEquals((Object)"", (Object)name);
    }
}

