/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.factory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactory;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactoryImpl;
import org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.factory.CaseManagementGraphFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.factory.impl.AbstractGraphFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.DirectGraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
public class CaseManagementGraphFactoryImpl
extends AbstractGraphFactory
implements CaseManagementGraphFactory {
    public static String START_EVENT_ID = BindableAdapterUtils.getDefinitionId(StartNoneEvent.class);
    public static String SUBPROCESS_ID = BindableAdapterUtils.getDefinitionId(AdHocSubprocess.class);
    public static String END_EVENT_ID = BindableAdapterUtils.getDefinitionId(EndNoneEvent.class);
    public static String SEQ_FLOW_ID = BindableAdapterUtils.getDefinitionId(SequenceFlow.class);
    private static final double CONNECTION_LOCATION_X = 475.0;
    private static final double CONNECTION_LOCATION_Y = 475.0;
    private final DefinitionManager definitionManager;
    private final RuleManager ruleManager;
    private final GraphIndexBuilder<?> indexBuilder;
    private final GraphCommandManager graphCommandManager;
    private final GraphCommandFactory graphCommandFactory;
    private final FactoryManager factoryManager;
    private final BPMNGraphFactory bpmnGraphFactory;
    private Class<? extends BPMNDiagram> diagramType;

    protected CaseManagementGraphFactoryImpl() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public CaseManagementGraphFactoryImpl(DefinitionManager definitionManager, FactoryManager factoryManager, RuleManager ruleManager, GraphCommandManager graphCommandManager, GraphCommandFactory graphCommandFactory, GraphIndexBuilder<?> indexBuilder, BPMNGraphFactoryImpl graphFactory) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
        this.ruleManager = ruleManager;
        this.graphCommandManager = graphCommandManager;
        this.graphCommandFactory = graphCommandFactory;
        this.indexBuilder = indexBuilder;
        this.diagramType = CaseManagementDiagram.class;
        this.bpmnGraphFactory = graphFactory;
    }

    @PostConstruct
    public void init() {
        this.bpmnGraphFactory.setDiagramType(CaseManagementDiagram.class);
    }

    public void setDiagramType(Class<? extends BPMNDiagram> diagramType) {
        this.diagramType = diagramType;
    }

    public Class<? extends ElementFactory> getFactoryType() {
        return CaseManagementGraphFactory.class;
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definitionSetId) {
        Graph graph = super.build(uuid, definitionSetId);
        List<Command> commands = this.buildInitialisationCommands();
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commands.forEach(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
        this.graphCommandManager.execute((Object)this.createGraphContext(graph), (Command)commandBuilder.build());
        return graph;
    }

    public boolean accepts(String source) {
        return true;
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    protected List<Command> buildInitialisationCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Node diagramNode = (Node)this.factoryManager.newElement(UUID.uuid(), BindableAdapterUtils.getDefinitionId(this.diagramType));
        Node startEventNode = (Node)this.factoryManager.newElement(UUID.uuid(), START_EVENT_ID);
        ((View)startEventNode.getContent()).setBounds(Bounds.create((double)50.0, (double)50.0, (double)105.0, (double)105.0));
        Node stageNode = (Node)this.factoryManager.newElement(UUID.uuid(), SUBPROCESS_ID);
        ((View)stageNode.getContent()).setBounds(Bounds.create((double)155.0, (double)50.0, (double)330.0, (double)100.0));
        Node endEventNode = (Node)this.factoryManager.newElement(UUID.uuid(), END_EVENT_ID);
        ((View)endEventNode.getContent()).setBounds(Bounds.create((double)380.0, (double)50.0, (double)435.0, (double)105.0));
        Edge startEventEdge = (Edge)this.factoryManager.newElement(UUID.uuid(), SEQ_FLOW_ID);
        Edge endEventEdge = (Edge)this.factoryManager.newElement(UUID.uuid(), SEQ_FLOW_ID);
        commands.add((Command)this.graphCommandFactory.addNode(diagramNode));
        commands.add((Command)this.graphCommandFactory.addChildNode(diagramNode, startEventNode));
        commands.add((Command)this.graphCommandFactory.addChildNode(diagramNode, stageNode));
        commands.add((Command)this.graphCommandFactory.addChildNode(diagramNode, endEventNode));
        commands.add((Command)this.graphCommandFactory.setSourceNode(startEventNode, startEventEdge, (Connection)new MagnetConnection.Builder().atX(475.0).atY(475.0).auto(true).build()));
        commands.add((Command)this.graphCommandFactory.setTargetNode(stageNode, startEventEdge, (Connection)new MagnetConnection.Builder().atX(475.0).atY(475.0).auto(true).build()));
        commands.add((Command)this.graphCommandFactory.setSourceNode(stageNode, endEventEdge, (Connection)new MagnetConnection.Builder().atX(475.0).atY(475.0).auto(true).build()));
        commands.add((Command)this.graphCommandFactory.setTargetNode(endEventNode, endEventEdge, (Connection)new MagnetConnection.Builder().atX(475.0).atY(475.0).auto(true).build()));
        return commands;
    }

    protected GraphCommandExecutionContext createGraphContext(Graph graph) {
        return new DirectGraphCommandExecutionContext(this.definitionManager, this.factoryManager, this.indexBuilder.build(graph));
    }
}

