/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.api;

import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.Adapter;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.clone.CloneManager;
import org.kie.workbench.common.stunner.core.registry.DynamicRegistry;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.kie.workbench.common.stunner.core.registry.definition.TypeDefinitionSetRegistry;

public abstract class AbstractDefinitionManager
implements DefinitionManager {
    private final TypeDefinitionSetRegistry<?> definitionSetRegistry;
    private final AdapterManager adapterManager;
    private final CloneManager cloneManager;

    protected AbstractDefinitionManager() {
        this.definitionSetRegistry = null;
        this.adapterManager = null;
        this.cloneManager = null;
    }

    public AbstractDefinitionManager(RegistryFactory registryFactory, AdapterManager adapterManager, CloneManager cloneManager) {
        this.definitionSetRegistry = registryFactory.newDefinitionSetRegistry();
        this.adapterManager = adapterManager;
        this.cloneManager = cloneManager;
    }

    public TypeDefinitionSetRegistry<?> definitionSets() {
        return this.definitionSetRegistry;
    }

    public AdapterManager adapters() {
        return this.adapterManager;
    }

    protected void addDefinitionSet(Object object) {
        ((DynamicRegistry)this.definitionSetRegistry).register(object);
    }

    protected void addAdapter(Adapter adapter) {
        DynamicRegistry adapterDynamicRegistry = (DynamicRegistry)this.adapterManager.registry();
        adapterDynamicRegistry.register((Object)adapter);
    }

    public CloneManager cloneManager() {
        return this.cloneManager;
    }
}

