/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.Factory;
import org.kie.workbench.common.stunner.core.factory.definition.DefinitionFactory;
import org.kie.workbench.common.stunner.core.factory.diagram.DiagramFactory;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.kie.workbench.common.stunner.core.registry.factory.TypeFactoryRegistry;

class FactoryRegistryImpl<T extends Factory<?>>
implements TypeFactoryRegistry<T> {
    private final AdapterManager adapterManager;
    private final List<DefinitionFactory<?>> definitionFactories = new LinkedList();
    private final Map<Class<? extends ElementFactory>, ElementFactory<?, ?, ?>> graphFactories = new HashMap();
    private final List<DiagramFactory<?, ?>> diagramFactories = new LinkedList();

    FactoryRegistryImpl(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    public DefinitionFactory<?> getDefinitionFactory(String id) {
        for (DefinitionFactory<?> factory : this.definitionFactories) {
            if (!factory.accepts(id)) continue;
            return factory;
        }
        return null;
    }

    public ElementFactory<?, ?, ?> getElementFactory(Class<? extends ElementFactory> type) {
        return this.graphFactories.get(type);
    }

    public DiagramFactory<?, ?> getDiagramFactory(String defSetId, Class<? extends Metadata> metadataType) {
        return this.diagramFactories.stream().filter(factory -> !factory.isDefault() && factory.accepts((Object)defSetId) && metadataType.equals(factory.getMetadataType())).findFirst().orElseGet(() -> this.getDefaultDiagramFactory(defSetId, metadataType));
    }

    private DiagramFactory<?, ?> getDefaultDiagramFactory(String defSetId, Class<? extends Metadata> metadataType) {
        return this.diagramFactories.stream().filter(factory -> factory.isDefault() && factory.accepts((Object)defSetId) && metadataType.equals(factory.getMetadataType())).findFirst().orElse(null);
    }

    public void register(T item) {
        if (item instanceof DefinitionFactory) {
            this.definitionFactories.add((DefinitionFactory)item);
        } else if (item instanceof ElementFactory) {
            this.graphFactories.put(((ElementFactory)item).getFactoryType(), (ElementFactory)item);
        } else if (item instanceof DiagramFactory) {
            this.diagramFactories.add((DiagramFactory)item);
        }
    }

    public boolean remove(T item) {
        if (item instanceof DefinitionFactory) {
            return this.definitionFactories.remove(item);
        }
        if (item instanceof ElementFactory) {
            return null != this.graphFactories.remove(((ElementFactory)item).getFactoryType());
        }
        if (item instanceof DiagramFactory) {
            return this.diagramFactories.remove(item);
        }
        return false;
    }

    public void clear() {
        this.definitionFactories.clear();
        this.graphFactories.clear();
        this.diagramFactories.clear();
    }

    public boolean contains(T item) {
        if (item instanceof DefinitionFactory) {
            return this.definitionFactories.contains(item);
        }
        if (item instanceof ElementFactory) {
            return this.graphFactories.containsValue(item);
        }
        if (item instanceof DiagramFactory) {
            return this.diagramFactories.contains(item);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.definitionFactories.isEmpty() && this.graphFactories.isEmpty();
    }

    public Collection<T> getAllFactories() {
        return new LinkedList<T>(){
            {
                this.addAll(FactoryRegistryImpl.this.definitionFactories);
                this.addAll(FactoryRegistryImpl.this.diagramFactories);
                this.addAll(FactoryRegistryImpl.this.graphFactories.values());
            }
        };
    }

    public DefinitionFactory<?> getDefinitionFactory(Class<?> type) {
        String id = BindableAdapterUtils.getDefinitionId(type, (AdapterRegistry)this.adapterManager.registry());
        return this.getDefinitionFactory(id);
    }
}

