/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.jbpm.workbench.ks.integration.KieServerDataSetProviderType;
import org.jbpm.workbench.ks.integration.RemoteDataSetDef;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.client.QueryServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KieServerDataSetProvider
extends AbstractKieServerService
implements DataSetProvider {
    public static final DataSetProviderType TYPE = new KieServerDataSetProviderType();
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerDataSetProvider.class);

    public DataSetProviderType getType() {
        return TYPE;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        QueryServicesClient queryClient;
        QueryDefinition definition;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        if (def.getColumns() == null && def instanceof RemoteDataSetDef && (definition = (queryClient = this.getClient(((RemoteDataSetDef)def).getServerTemplateId(), QueryServicesClient.class)).getQuery(def.getUUID())).getColumns() != null) {
            for (Map.Entry entry : definition.getColumns().entrySet()) {
                if (def.getColumnById((String)entry.getKey()) != null) continue;
                def.addColumn((String)entry.getKey(), ColumnType.valueOf((String)((String)entry.getValue())));
            }
        }
        List columns = def.getColumns();
        for (DataColumnDef column : columns) {
            columnNames.add(column.getId());
            columnTypes.add(column.getColumnType());
        }
        return new DataSetMetadataImpl(def, def.getUUID(), -1, def.getColumns().size(), columnNames, columnTypes, -1);
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        DataSetSort sort;
        ConsoleDataSetLookup dataSetLookup = this.adoptLookup(def, lookup);
        LOGGER.debug("Data Set lookup using Server Template Id: {}", (Object)dataSetLookup.getServerTemplateId());
        if (dataSetLookup.getServerTemplateId() == null || dataSetLookup.getServerTemplateId().isEmpty()) {
            return this.buildDataSet(def, new ArrayList<List>(), new ArrayList<DataColumn>());
        }
        QueryServicesClient queryClient = this.getClient(dataSetLookup.getServerTemplateId(), QueryServicesClient.class);
        ArrayList<QueryParam> filterParams = new ArrayList<QueryParam>();
        QueryFilterSpec filterSpec = new QueryFilterSpec();
        for (DataSetFilter filter : dataSetLookup.getOperationList(DataSetFilter.class)) {
            if (filter == null) continue;
            for (ColumnFilter cFilter : filter.getColumnFilterList()) {
                if (cFilter instanceof CoreFunctionFilter) {
                    CoreFunctionFilter coreFunctionFilter = (CoreFunctionFilter)cFilter;
                    filterParams.add(new QueryParam(coreFunctionFilter.getColumnId(), coreFunctionFilter.getType().toString(), coreFunctionFilter.getParameters()));
                    continue;
                }
                if (!(cFilter instanceof LogicalExprFilter)) continue;
                LogicalExprFilter logicalExprFilter = (LogicalExprFilter)cFilter;
                filterParams.add(new QueryParam(logicalExprFilter.getColumnId(), logicalExprFilter.getLogicalOperator().toString(), logicalExprFilter.getLogicalTerms()));
            }
        }
        ArrayList<DataColumn> extraColumns = new ArrayList<DataColumn>();
        List dataSetGroups = lookup.getFirstGroupOpSelections();
        for (DataSetGroup group : dataSetGroups) {
            if (group.getSelectedIntervalList() == null || group.getSelectedIntervalList().size() <= 0) continue;
            this.appendIntervalSelection(group, filterParams);
        }
        DataSetGroup dataSetGroup = dataSetLookup.getLastGroupOp();
        this.handleDataSetGroup(def, dataSetGroup, filterParams, extraColumns);
        if (!filterParams.isEmpty()) {
            filterSpec.setParameters(filterParams.toArray(new QueryParam[filterParams.size()]));
        }
        if ((sort = dataSetLookup.getFirstSortOp()) != null) {
            SortOrder sortOrder = SortOrder.UNSPECIFIED;
            StringBuilder orderBy = new StringBuilder();
            for (ColumnSort cSort : sort.getColumnSortList()) {
                orderBy.append(cSort.getColumnId()).append(",");
                sortOrder = cSort.getOrder();
            }
            orderBy.deleteCharAt(orderBy.length() - 1);
            filterSpec.setOrderBy(orderBy.toString());
            filterSpec.setAscending(sortOrder.equals((Object)SortOrder.ASCENDING));
        }
        List<List> instances = this.performQuery((RemoteDataSetDef)def, dataSetLookup, queryClient, filterSpec);
        LOGGER.debug("Query client returned {} row(s)", (Object)instances.size());
        return this.buildDataSet(def, instances, extraColumns);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ConsoleDataSetLookup adoptLookup(DataSetDef def, DataSetLookup lookup) {
        ConsoleDataSetLookup dataSetLookup = null;
        if (lookup instanceof ConsoleDataSetLookup) return (ConsoleDataSetLookup)lookup;
        if (!(def instanceof RemoteDataSetDef)) throw new IllegalArgumentException("DataSetLookup is of incorrect type " + lookup.getClass().getName());
        dataSetLookup = (ConsoleDataSetLookup)ConsoleDataSetLookup.fromInstance((DataSetLookup)lookup, (String)((RemoteDataSetDef)def).getServerTemplateId());
        DataSetFilter filter = def.getDataSetFilter();
        if (filter == null) return dataSetLookup;
        dataSetLookup.addOperation(new DataSetOp[]{filter});
        return dataSetLookup;
    }

    protected List<List> performQuery(RemoteDataSetDef def, ConsoleDataSetLookup dataSetLookup, QueryServicesClient queryClient, QueryFilterSpec filterSpec) {
        if (dataSetLookup.testMode()) {
            QueryDefinition queryDefinition = QueryDefinition.builder().name(dataSetLookup.getDataSetUUID()).source(def.getDataSource()).target(def.getQueryTarget()).expression(def.getDbSQL()).build();
            this.kieServerIntegration.broadcastToKieServers(def.getServerTemplateId(), client -> {
                QueryServicesClient instanceQueryClient = (QueryServicesClient)client.getServicesClient(QueryServicesClient.class);
                QueryDefinition registered = instanceQueryClient.replaceQuery(queryDefinition);
                if (registered.getColumns() != null) {
                    for (Map.Entry entry : registered.getColumns().entrySet()) {
                        if (def.getColumnById((String)entry.getKey()) != null) continue;
                        def.addColumn((String)entry.getKey(), ColumnType.valueOf((String)((String)entry.getValue())));
                    }
                }
                return registered;
            });
            try {
                return queryClient.query(dataSetLookup.getDataSetUUID(), "RawList", filterSpec, Integer.valueOf(dataSetLookup.getRowOffset() / dataSetLookup.getNumberOfRows()), Integer.valueOf(dataSetLookup.getNumberOfRows()), List.class);
            }
            catch (Exception e) {
                queryClient.unregisterQuery(dataSetLookup.getDataSetUUID());
                throw new RuntimeException(e);
            }
        }
        return queryClient.query(dataSetLookup.getDataSetUUID(), "RawList", filterSpec, Integer.valueOf(dataSetLookup.getRowOffset() / dataSetLookup.getNumberOfRows()), Integer.valueOf(dataSetLookup.getNumberOfRows()), List.class);
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        return false;
    }

    protected DataSet buildDataSet(DataSetDef def, List<List> instances, List<DataColumn> extraColumns) throws Exception {
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setUUID(def.getUUID());
        dataSet.setDefinition(def);
        if (extraColumns != null && !extraColumns.isEmpty()) {
            for (DataColumn extraColumn : extraColumns) {
                dataSet.addColumn(extraColumn);
            }
        } else {
            for (DataColumnDef column : def.getColumns()) {
                DataColumnImpl numRows = new DataColumnImpl(column.getId(), column.getColumnType());
                dataSet.addColumn((DataColumn)numRows);
            }
        }
        for (List row : instances) {
            int columnIndex = 0;
            for (Object value : row) {
                DataColumn intervalBuilder = dataSet.getColumnByIndex(columnIndex);
                if (intervalBuilder.getColumnType().equals((Object)ColumnType.DATE) && value instanceof Long) {
                    intervalBuilder.getValues().add(new Date((Long)value));
                } else {
                    intervalBuilder.getValues().add(value);
                }
                ++columnIndex;
            }
        }
        dataSet.setRowCountNonTrimmed(instances.size());
        return dataSet;
    }

    protected void appendIntervalSelection(DataSetGroup intervalSel, List<QueryParam> filterParams) {
        if (intervalSel != null && intervalSel.isSelect()) {
            ColumnGroup cg = intervalSel.getColumnGroup();
            List intervalList = intervalSel.getSelectedIntervalList();
            ArrayList<String> names = new ArrayList<String>();
            Comparable min = null;
            Comparable max = null;
            for (Interval interval : intervalList) {
                names.add(interval.getName());
                Comparable intervalMin = (Comparable)interval.getMinValue();
                Comparable intervalMax = (Comparable)interval.getMaxValue();
                if (intervalMin != null) {
                    if (min == null) {
                        min = intervalMin;
                    } else if (min.compareTo(intervalMin) > 0) {
                        min = intervalMin;
                    }
                }
                if (intervalMax == null) continue;
                if (max == null) {
                    max = intervalMax;
                    continue;
                }
                if (max.compareTo(intervalMax) <= 0) continue;
                max = intervalMax;
            }
            if (min != null && max != null && min.compareTo(max) > 0) {
                min = max;
            }
            ColumnFilter filter = min != null && max != null ? FilterFactory.between((String)cg.getSourceId(), (Comparable)min, max) : (min != null ? FilterFactory.greaterOrEqualsTo((String)cg.getSourceId(), (Comparable)min) : (max != null ? FilterFactory.lowerOrEqualsTo((String)cg.getSourceId(), max) : FilterFactory.equalsTo((String)cg.getSourceId(), names)));
            CoreFunctionFilter coreFunctionFilter = (CoreFunctionFilter)filter;
            filterParams.add(new QueryParam(coreFunctionFilter.getColumnId(), coreFunctionFilter.getType().toString(), coreFunctionFilter.getParameters()));
        }
    }

    protected void handleDataSetGroup(DataSetDef def, DataSetGroup dataSetGroup, List<QueryParam> filterParams, List<DataColumn> extraColumns) {
        if (dataSetGroup != null) {
            if (dataSetGroup.getColumnGroup() != null) {
                if (dataSetGroup.getColumnGroup().getIntervalSize() != null) {
                    filterParams.add(new QueryParam(dataSetGroup.getColumnGroup().getSourceId(), "group", Arrays.asList(dataSetGroup.getColumnGroup().getColumnId(), dataSetGroup.getColumnGroup().getIntervalSize(), dataSetGroup.getColumnGroup().getMaxIntervals())));
                } else {
                    filterParams.add(new QueryParam(dataSetGroup.getColumnGroup().getSourceId(), "group", Arrays.asList(dataSetGroup.getColumnGroup().getColumnId())));
                }
            }
            for (GroupFunction groupFunction : dataSetGroup.getGroupFunctions()) {
                if (groupFunction.getFunction() != null) {
                    filterParams.add(new QueryParam(groupFunction.getSourceId(), groupFunction.getFunction().toString(), Arrays.asList(groupFunction.getColumnId())));
                    extraColumns.add((DataColumn)new DataColumnImpl(groupFunction.getSourceId(), ColumnType.NUMBER));
                    continue;
                }
                filterParams.add(new QueryParam(groupFunction.getSourceId(), null, Arrays.asList(groupFunction.getColumnId())));
                extraColumns.add((DataColumn)new DataColumnImpl(groupFunction.getSourceId(), this.getGroupFunctionColumnType(def, dataSetGroup.getColumnGroup(), groupFunction)));
            }
        }
    }

    protected ColumnType getGroupFunctionColumnType(DataSetDef def, ColumnGroup columnGroup, GroupFunction groupFunction) {
        ColumnType type = def.getColumnById(groupFunction.getColumnId()).getColumnType();
        if (type != ColumnType.DATE || columnGroup == null || groupFunction == null) {
            return type;
        }
        return columnGroup.getSourceId().equals(groupFunction.getSourceId()) ? ColumnType.LABEL : type;
    }
}

