/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import com.thoughtworks.xstream.XStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.events.DeleteModuleEvent;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.backend.server.ProjectExplorerContentResolver;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.concurrent.Managed;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@Dependent
public class ExplorerServiceImpl
implements ExplorerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorerServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="configIO")
    private IOService ioServiceConfig;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    private KieModuleService moduleService;
    @Inject
    private ExplorerServiceHelper helper;
    @Inject
    private UserServicesImpl userServices;
    @Inject
    private UserServicesBackendImpl userServicesBackend;
    @Inject
    private ProjectExplorerContentResolver projectExplorerContentResolver;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private CopyService copyService;
    @Inject
    private WorkspaceProjectService projectService;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @Managed
    private ExecutorService executorService;
    @Inject
    SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Inject
    OrganizationalUnitService organizationalUnitService;
    private XStream xs = XStreamUtils.createTrustingXStream();

    public WorkspaceProject resolveProject(String path) {
        return this.projectService.resolveProject(Paths.convert((Path)this.ioService.get(URI.create(path.trim()))));
    }

    public ProjectExplorerContent getContent(String _path, ActiveOptions activeOptions) {
        PortablePreconditions.checkNotEmpty((String)"path", (String)_path);
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.ioService.get(URI.create(_path.trim())));
        Module module = this.moduleService.resolveModule(path);
        org.uberfire.backend.vfs.Path convertedPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).getRoot());
        Repository repo = this.repositoryService.getRepository(convertedPath);
        Branch branch = this.getBranch(repo, convertedPath);
        return this.getContent(new ProjectExplorerContentQuery(repo, branch, module, activeOptions));
    }

    private Branch getBranch(Repository repository, org.uberfire.backend.vfs.Path convertedPath) {
        for (Branch branch : repository.getBranches()) {
            if (!branch.getPath().equals(convertedPath)) continue;
            return branch;
        }
        return null;
    }

    public ProjectExplorerContent getContent(ProjectExplorerContentQuery query) {
        return this.projectExplorerContentResolver.resolve(query);
    }

    public FolderListing getFolderListing(final WorkspaceProject project, final Module module, final FolderItem item, final ActiveOptions options) {
        FolderListing result = this.helper.getFolderListing(item, options);
        if (result != null) {
            final Path userNavPath = this.userServices.buildPath("explorer", "user.nav");
            final Path lastUserNavPath = this.userServices.buildPath("explorer", "last.user.nav");
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "Serialize Navigation State";
                }

                public void run() {
                    try {
                        Package pkg = null;
                        if (item.getItem() instanceof Package) {
                            pkg = (Package)item.getItem();
                        }
                        ExplorerServiceImpl.this.helper.store(userNavPath, lastUserNavPath, project, module, pkg, item, options);
                    }
                    catch (Exception e) {
                        LOGGER.error("Can't serialize user's state navigation", (Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    private List<org.uberfire.backend.vfs.Path> resolvePath(final FolderItem item) {
        if (item == null) {
            return Collections.emptyList();
        }
        if (item.getItem() instanceof Package) {
            final Package pkg = (Package)item.getItem();
            return new ArrayList<org.uberfire.backend.vfs.Path>(4){
                {
                    super(x0);
                    this.add(pkg.getPackageMainResourcesPath());
                    this.add(pkg.getPackageMainSrcPath());
                    this.add(pkg.getPackageTestResourcesPath());
                    this.add(pkg.getPackageTestSrcPath());
                }
            };
        }
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            if (item.getType() == FolderItemType.FOLDER) {
                final Package pkg = this.moduleService.resolvePackage((org.uberfire.backend.vfs.Path)item.getItem());
                if (pkg == null) {
                    return new ArrayList<org.uberfire.backend.vfs.Path>(1){
                        {
                            super(x0);
                            this.add((org.uberfire.backend.vfs.Path)item.getItem());
                        }
                    };
                }
                return new ArrayList<org.uberfire.backend.vfs.Path>(4){
                    {
                        super(x0);
                        this.add(pkg.getPackageMainResourcesPath());
                        this.add(pkg.getPackageMainSrcPath());
                        this.add(pkg.getPackageTestResourcesPath());
                        this.add(pkg.getPackageTestSrcPath());
                    }
                };
            }
            return new ArrayList<org.uberfire.backend.vfs.Path>(1){
                {
                    super(x0);
                    this.add((org.uberfire.backend.vfs.Path)item.getItem());
                }
            };
        }
        return Collections.emptyList();
    }

    public Package resolvePackage(FolderItem item) {
        if (item == null) {
            return null;
        }
        if (item.getItem() instanceof Package) {
            return (Package)item.getItem();
        }
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            return this.moduleService.resolvePackage((org.uberfire.backend.vfs.Path)item.getItem());
        }
        return null;
    }

    public Set<Option> getLastUserOptions() {
        return this.helper.getLastContent().getOptions();
    }

    public void deleteItem(FolderItem folderItem, String comment) {
        List<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        this.deleteService.deleteIfExists(paths, comment);
    }

    public void renameItem(FolderItem folderItem, String newName, String comment) {
        List<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        this.renameService.renameIfExists(paths, newName, comment);
    }

    public void copyItem(FolderItem folderItem, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        List<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        if (paths != null && paths.size() == 1) {
            this.copyService.copy(paths.get(0), newName, targetDirectory, comment);
        } else {
            this.copyService.copyIfExists(paths, newName, comment);
        }
    }

    void onModuleUpdate(@Observes ModuleUpdatedEvent event) {
        this.cleanup(event.getOldModule());
    }

    void onModuleDelete(@Observes DeleteModuleEvent event) {
        this.cleanup(event.getModule());
    }

    private void cleanup(Module module) {
        Collection lastNavs = this.userServicesBackend.getAllUsersData("explorer", "last.user.nav");
        Collection userNavs = this.userServicesBackend.getAllUsersData("explorer", "user.nav");
        WorkspaceProject project = this.projectService.resolveProject(module.getRootPath());
        this.spaceConfigStorageRegistry.getBatch(project.getSpace().getName()).run(context -> {
            for (Path path : userNavs) {
                UserExplorerData userContent = this.helper.loadUserContent(path);
                if (userContent == null || !userContent.deleteModule(module)) continue;
                this.ioServiceConfig.write(path, this.xs.toXML((Object)userContent), new OpenOption[0]);
            }
            for (Path lastNav : lastNavs) {
                UserExplorerLastData lastUserContent = this.helper.getLastContent(lastNav);
                if (lastUserContent == null || !lastUserContent.deleteModule(module)) continue;
                this.ioServiceConfig.write(lastNav, this.xs.toXML((Object)lastUserContent), new OpenOption[0]);
            }
            return null;
        });
    }

    public class OrganizationalUnitNotFoundForURI
    extends RuntimeException {
    }
}

