/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.UberfireRoleManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.keycloak.KCAdapterClientFactory;
import org.uberfire.ext.security.management.keycloak.KeyCloakGroupManager;
import org.uberfire.ext.security.management.keycloak.KeyCloakUserManager;
import org.uberfire.ext.security.management.service.AbstractUserManagementService;

@Dependent
@Named(value="KCAdapterUserManagementService")
public class KCAdapterUserManagementService
extends AbstractUserManagementService {
    KeyCloakUserManager userManager;
    KeyCloakGroupManager groupManager;
    KCAdapterClientFactory clientFactory;
    HttpServletRequest request;

    @Inject
    public KCAdapterUserManagementService(KeyCloakUserManager userManager, KeyCloakGroupManager groupManager, KCAdapterClientFactory clientFactory, HttpServletRequest request, @Named(value="uberfireRoleManager") UberfireRoleManager roleManager) {
        super(roleManager);
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.clientFactory = clientFactory;
        this.request = request;
    }

    @PostConstruct
    public void init() {
        this.clientFactory.init(new ConfigProperties(System.getProperties()), this.request);
        this.userManager.init(this.clientFactory);
        this.groupManager.init(this.clientFactory);
    }

    public UserManager users() {
        return this.userManager;
    }

    public GroupManager groups() {
        return this.groupManager;
    }
}

