/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events;

import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.ThrowEvent;
import org.kie.workbench.common.stunner.bpmn.backend.converters.NodeMatch;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ThrowEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BaseThrowingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class IntermediateThrowEventConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public IntermediateThrowEventConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public PropertyWriter toFlowElement(Node<View<BaseThrowingIntermediateEvent>, ?> node) {
        return NodeMatch.fromNode(BaseThrowingIntermediateEvent.class, PropertyWriter.class).when(IntermediateMessageEventThrowing.class, this::messageEvent).when(IntermediateSignalEventThrowing.class, this::signalEvent).when(IntermediateEscalationEventThrowing.class, this::escalationEvent).when(IntermediateCompensationEventThrowing.class, this::compensationEvent).apply(node).value();
    }

    private PropertyWriter signalEvent(Node<View<IntermediateSignalEventThrowing>, ?> n) {
        IntermediateThrowEvent event = Factories.bpmn2.createIntermediateThrowEvent();
        event.setId(n.getUUID());
        IntermediateSignalEventThrowing definition = (IntermediateSignalEventThrowing)((View)n.getContent()).getDefinition();
        ThrowEventPropertyWriter p = this.propertyWriterFactory.of((ThrowEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        p.addSignal(definition.getExecutionSet().getSignalRef());
        p.addSignalScope(definition.getExecutionSet().getSignalScope());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter messageEvent(Node<View<IntermediateMessageEventThrowing>, ?> n) {
        IntermediateThrowEvent event = Factories.bpmn2.createIntermediateThrowEvent();
        event.setId(n.getUUID());
        IntermediateMessageEventThrowing definition = (IntermediateMessageEventThrowing)((View)n.getContent()).getDefinition();
        ThrowEventPropertyWriter p = this.propertyWriterFactory.of((ThrowEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        MessageEventExecutionSet executionSet = definition.getExecutionSet();
        p.addMessage(executionSet.getMessageRef());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter escalationEvent(Node<View<IntermediateEscalationEventThrowing>, ?> n) {
        IntermediateThrowEvent event = Factories.bpmn2.createIntermediateThrowEvent();
        event.setId(n.getUUID());
        IntermediateEscalationEventThrowing definition = (IntermediateEscalationEventThrowing)((View)n.getContent()).getDefinition();
        ThrowEventPropertyWriter p = this.propertyWriterFactory.of((ThrowEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        p.addEscalation(definition.getExecutionSet().getEscalationRef());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter compensationEvent(Node<View<IntermediateCompensationEventThrowing>, ?> n) {
        IntermediateThrowEvent event = Factories.bpmn2.createIntermediateThrowEvent();
        event.setId(n.getUUID());
        IntermediateCompensationEventThrowing definition = (IntermediateCompensationEventThrowing)((View)n.getContent()).getDefinition();
        ThrowEventPropertyWriter p = this.propertyWriterFactory.of((ThrowEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.addCompensation();
        p.setAbsoluteBounds(n);
        return p;
    }
}

