/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TerminateEventDefinition;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.common.ConditionExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettings;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;

public abstract class EventPropertyWriter
extends PropertyWriter {
    public EventPropertyWriter(Event event, VariableScope variableScope) {
        super((FlowElement)event, variableScope);
    }

    public abstract void setAssignmentsInfo(AssignmentsInfo var1);

    public void addMessage(MessageRef messageRef) {
        MessageEventDefinition messageEventDefinition = Factories.bpmn2.createMessageEventDefinition();
        this.addEventDefinition((EventDefinition)messageEventDefinition);
        String name = messageRef.getValue();
        if (name == null || name.isEmpty()) {
            return;
        }
        ItemDefinition itemDefinition = Factories.bpmn2.createItemDefinition();
        itemDefinition.setId(Ids.messageItem(name));
        Message message = Factories.bpmn2.createMessage();
        message.setName(name);
        message.setItemRef(itemDefinition);
        messageEventDefinition.setMessageRef(message);
        CustomAttribute.msgref.of((BaseElement)messageEventDefinition).set(name);
        this.addItemDefinition(itemDefinition);
        this.addRootElement((RootElement)message);
    }

    public void addSignal(SignalRef signalRef) {
        SignalEventDefinition signalEventDefinition = Factories.bpmn2.createSignalEventDefinition();
        this.addEventDefinition((EventDefinition)signalEventDefinition);
        Signal signal = Factories.bpmn2.createSignal();
        String name = signalRef.getValue();
        if (name == null || name.isEmpty()) {
            return;
        }
        signal.setName(name);
        signal.setId(Ids.fromString(name));
        signalEventDefinition.setSignalRef(signal.getId());
        this.addRootElement((RootElement)signal);
    }

    public void addSignalScope(SignalScope signalScope) {
        CustomElement.scope.of((BaseElement)this.flowElement).set(signalScope.getValue());
    }

    public void addError(ErrorRef errorRef) {
        Error error = Factories.bpmn2.createError();
        ErrorEventDefinition errorEventDefinition = Factories.bpmn2.createErrorEventDefinition();
        this.addEventDefinition((EventDefinition)errorEventDefinition);
        String errorCode = errorRef.getValue();
        if (errorCode == null || errorCode.isEmpty()) {
            return;
        }
        error.setId(errorCode);
        error.setErrorCode(errorCode);
        errorEventDefinition.setErrorRef(error);
        CustomAttribute.errorName.of((BaseElement)errorEventDefinition).set(errorCode);
        this.addRootElement((RootElement)error);
    }

    public void addTerminate() {
        TerminateEventDefinition terminateEventDefinition = Factories.bpmn2.createTerminateEventDefinition();
        this.addEventDefinition((EventDefinition)terminateEventDefinition);
    }

    public void addTimer(TimerSettings timerSettings) {
        String duration;
        TimerEventDefinition eventDefinition = Factories.bpmn2.createTimerEventDefinition();
        TimerSettingsValue timerSettingsValue = timerSettings.getValue();
        String date = timerSettingsValue.getTimeDate();
        if (date != null) {
            FormalExpression timeDate = Factories.bpmn2.createFormalExpression();
            timeDate.setBody(date);
            eventDefinition.setTimeDate((Expression)timeDate);
        }
        if ((duration = timerSettingsValue.getTimeDuration()) != null) {
            FormalExpression timeDuration = Factories.bpmn2.createFormalExpression();
            timeDuration.setBody(duration);
            eventDefinition.setTimeDuration((Expression)timeDuration);
        }
        String cycle = timerSettingsValue.getTimeCycle();
        String cycleLanguage = timerSettingsValue.getTimeCycleLanguage();
        if (cycle != null && cycleLanguage != null) {
            FormalExpression timeCycleExpression = Factories.bpmn2.createFormalExpression();
            timeCycleExpression.setBody(cycle);
            timeCycleExpression.setLanguage(cycleLanguage);
            eventDefinition.setTimeCycle((Expression)timeCycleExpression);
        }
        this.addEventDefinition((EventDefinition)eventDefinition);
    }

    public void addCondition(ConditionExpression condition) {
        ConditionalEventDefinition conditionalEventDefinition = Factories.bpmn2.createConditionalEventDefinition();
        FormalExpression conditionExpression = Factories.bpmn2.createFormalExpression();
        String languageFormat = Scripts.scriptLanguageToUri(condition.getValue().getLanguage(), Scripts.LANGUAGE.DROOLS.format());
        conditionExpression.setLanguage(languageFormat);
        String conditionScript = condition.getValue().getScript();
        if (conditionScript != null && !conditionScript.isEmpty()) {
            conditionExpression.setBody(Scripts.asCData(conditionScript));
        }
        conditionalEventDefinition.setCondition((Expression)conditionExpression);
        this.addEventDefinition((EventDefinition)conditionalEventDefinition);
    }

    public void addEscalation(EscalationRef escalationRef) {
        EscalationEventDefinition escalationEventDefinition = Factories.bpmn2.createEscalationEventDefinition();
        this.addEventDefinition((EventDefinition)escalationEventDefinition);
        Escalation escalation = Factories.bpmn2.createEscalation();
        String escalationCode = escalationRef.getValue();
        if (escalationCode == null || escalationCode.isEmpty()) {
            return;
        }
        escalation.setId(Ids.fromString(escalationCode));
        escalation.setEscalationCode(escalationCode);
        escalationEventDefinition.setEscalationRef(escalation);
        CustomAttribute.esccode.of((BaseElement)escalationEventDefinition).set(escalationCode);
        this.addRootElement((RootElement)escalation);
    }

    public void addCompensation() {
        CompensateEventDefinition compensationEventDefinition = Factories.bpmn2.createCompensateEventDefinition();
        this.addEventDefinition((EventDefinition)compensationEventDefinition);
    }

    public void addSlaDueDate(SLADueDate slaDueDate) {
        CustomElement.slaDueDate.of((BaseElement)this.flowElement).set(slaDueDate.getValue());
    }

    protected abstract void addEventDefinition(EventDefinition var1);
}

