/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.bind;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackendBindableDefinitionSetAdapter<T>
extends AbstractReflectDefinitionSetAdapter<T>
implements BindableDefinitionSetAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendBindableDefinitionSetAdapter.class);
    private Map<Class, String> propertyDescriptionFieldNames;
    private Map<Class, Class> graphFactoryTypes;
    private Set<String> definitionIds;
    private Map<Class, Annotation> qualifiers;

    BackendBindableDefinitionSetAdapter() {
    }

    public void setBindings(Map<Class, String> propertyDescriptionFieldNames, Map<Class, Class> graphFactoryTypes, Map<Class, Annotation> qualifiers, Set<String> definitionIds) {
        this.propertyDescriptionFieldNames = propertyDescriptionFieldNames;
        this.graphFactoryTypes = graphFactoryTypes;
        this.definitionIds = definitionIds;
        this.qualifiers = qualifiers;
    }

    public String getDescription(T definitionSet) {
        Class<?> type = definitionSet.getClass();
        try {
            return (String)this.getFieldValue(definitionSet, this.propertyDescriptionFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining description for Definition Set with id " + this.getId(definitionSet));
            return null;
        }
    }

    public Set<String> getDefinitions(T definitionSet) {
        return this.getAnnotatedDefinitions(definitionSet);
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T definitionSet) {
        Class<?> type = definitionSet.getClass();
        return this.graphFactoryTypes.get(type);
    }

    public Annotation getQualifier(T definitionSet) {
        Class<?> type = definitionSet.getClass();
        return this.qualifiers.get(type);
    }

    public boolean accepts(Class<?> type) {
        return null != this.graphFactoryTypes && this.graphFactoryTypes.containsKey(type);
    }
}

