/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DomainValidator;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.ElementViolation;
import org.kie.workbench.common.stunner.core.validation.impl.ElementViolationImpl;
import org.kie.workbench.common.stunner.project.service.ProjectValidationService;

@ApplicationScoped
@Service
public class ProjectValidationServiceImpl
implements ProjectValidationService {
    private final Instance<DomainValidator> validators;

    protected ProjectValidationServiceImpl() {
        this(null);
    }

    @Inject
    public ProjectValidationServiceImpl(Instance<DomainValidator> validators) {
        this.validators = validators;
    }

    public Collection<DiagramElementViolation<RuleViolation>> validate(Diagram diagram) {
        return this.domainViolations(diagram).stream().filter(v -> Objects.nonNull(v.getUUID())).filter(v -> !"null".equals(v.getUUID())).collect(Collectors.groupingBy(ElementViolation::getUUID)).entrySet().stream().map(e -> new ElementViolationImpl.Builder().setUuid((String)e.getKey()).setDomainViolations((Collection)e.getValue()).build()).collect(Collectors.toList());
    }

    private Collection<DomainViolation> domainViolations(Diagram diagram) {
        return StreamSupport.stream(this.validators.spliterator(), false).filter(validator -> Objects.equals(validator.getDefinitionSetId(), diagram.getMetadata().getDefinitionSetId())).findFirst().map(validator -> {
            ArrayList domainViolations = new ArrayList();
            validator.validate((Object)diagram, domainViolations::addAll);
            return domainViolations;
        }).orElseGet(Collections::emptyList);
    }
}

