/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsConstraintFactory<Solution_>
implements InnerConstraintFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final String defaultConstraintPackage;
    private final AtomicInteger createdRuleCounter = new AtomicInteger();

    public DroolsConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        ConstraintConfigurationDescriptor<Solution_> configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? solutionDescriptor.getSolutionClass().getPackage().getName() : configurationDescriptor.getConstraintPackage();
    }

    @Override
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> fromClass) {
        return new DroolsFromUniConstraintStream(this, fromClass);
    }

    @Override
    public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> joiner) {
        MemberAccessor planningIdMemberAccessor = ConfigUtils.findPlanningIdMemberAccessor(fromClass);
        if (planningIdMemberAccessor == null) {
            throw new IllegalArgumentException("The fromClass (" + fromClass + ") has no member with a @" + PlanningId.class.getSimpleName() + " annotation, so the pairs can be made unique ([A,B] vs [B,A]).");
        }
        Function<Object, Comparable> planningIdGetter = fact -> (Comparable)planningIdMemberAccessor.executeGetter(fact);
        return this.from(fromClass).join(fromClass, joiner, Joiners.lessThan(planningIdGetter));
    }

    @Override
    public ConstraintSessionFactory<Solution_> buildSessionFactory(Constraint[] constraints) {
        ModelImpl model = new ModelImpl();
        AbstractScoreHolder scoreHolder = (AbstractScoreHolder)this.solutionDescriptor.getScoreDefinition().buildScoreHolder(false);
        Class<?> scoreHolderClass = scoreHolder.getClass();
        Global scoreHolderGlobal = DSL.globalOf(scoreHolderClass, (String)this.solutionDescriptor.getSolutionClass().getPackage().getName(), (String)"scoreHolder");
        model.addGlobal(scoreHolderGlobal);
        ArrayList droolsConstraintList = new ArrayList(constraints.length);
        HashSet<String> constraintIdSet = new HashSet<String>(constraints.length);
        LinkedHashMap ruleLibrary = new LinkedHashMap();
        for (Constraint constraint : constraints) {
            if (constraint.getConstraintFactory() != this) {
                throw new IllegalStateException("The constraint (" + constraint.getConstraintId() + ") must be created from the same constraintFactory.");
            }
            boolean added = constraintIdSet.add(constraint.getConstraintId());
            if (!added) {
                throw new IllegalStateException("There are 2 constraints with the same constraintName (" + constraint.getConstraintName() + ") in the same constraintPackage (" + constraint.getConstraintPackage() + ").");
            }
            DroolsConstraint droolsConstraint = (DroolsConstraint)constraint;
            droolsConstraintList.add(droolsConstraint);
            droolsConstraint.createRules(ruleLibrary, scoreHolderGlobal);
        }
        ruleLibrary.values().forEach(arg_0 -> ((ModelImpl)model).addRule(arg_0));
        InternalKnowledgeBase kieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseOption[])new KieBaseOption[0]);
        return new DroolsConstraintSessionFactory<Solution_>(this.solutionDescriptor, (KieBase)kieBase, droolsConstraintList);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public int getNextRuleId() {
        return this.createdRuleCounter.incrementAndGet();
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

