/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate1;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsLogicalTuple;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;

public class DroolsGroupingBiConstraintStream<Solution_, A, NewA, ResultContainer_, NewB>
extends DroolsAbstractBiConstraintStream<Solution_, NewA, NewB> {
    private final DroolsAbstractUniConstraintStream<Solution_, A> parent;
    private final Function<A, NewA> groupKeyMapping;
    private final UniConstraintCollector<A, ResultContainer_, NewB> collector;
    private int ruleId = -1;

    public DroolsGroupingBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, Function<A, NewA> groupKeyMapping, UniConstraintCollector<A, ResultContainer_, NewB> collector) {
        super(constraintFactory);
        this.parent = parent;
        this.groupKeyMapping = groupKeyMapping;
        this.collector = collector;
    }

    @Override
    public Optional<Rule> buildRule(DroolsConstraint<Solution_> constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        Integer createdRuleId = this.createRuleIdIfAbsent((DroolsConstraintFactory<Solution_>)constraint.getConstraintFactory());
        String ruleName = "Helper rule #" + createdRuleId + " (GroupBy remapping+collecting)";
        Rule rule = PatternDSL.rule((String)constraint.getConstraintPackage(), (String)ruleName).build(this.parent.createCondition().completeWithLogicalInsert(createdRuleId, this.groupKeyMapping, this.collector).toArray(new RuleItemBuilder[0]));
        return Optional.of(rule);
    }

    @Override
    public DroolsBiCondition<NewA, NewB> createCondition() {
        return new DroolsBiCondition((Declaration<DroolsLogicalTuple>)DSL.declarationOf(DroolsLogicalTuple.class), var -> {
            Integer createdRuleId = this.createRuleIdIfAbsent((DroolsConstraintFactory<Solution_>)this.getConstraintFactory());
            return PatternDSL.pattern((Variable)var).expr((Predicate1 & Serializable)logicalTuple -> Objects.equals(logicalTuple.getRuleId(), createdRuleId));
        });
    }

    private int createRuleIdIfAbsent(DroolsConstraintFactory<Solution_> constraintFactory) {
        if (this.ruleId < 0) {
            this.ruleId = constraintFactory.getNextRuleId();
        }
        return this.ruleId;
    }

    @Override
    protected DroolsAbstractConstraintStream<Solution_> getParent() {
        return this.parent;
    }

    public String toString() {
        return "BiGroup() with " + this.getChildStreams().size() + " children";
    }
}

