/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import org.eclipse.bpmn2.BaseElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.ElementDefinition;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CustomElementTest {
    private ElementDefinition<Object> elementDefinition;
    private Object defaultValue = new Object();
    @Mock
    private BaseElement baseElement;

    @Before
    public void setUp() {
        this.elementDefinition = new ElementDefinitionStub("someDefinition", this.defaultValue);
    }

    @Test
    public void testGet() {
        Object value = new Object();
        this.elementDefinition.setValue(this.baseElement, value);
        Assert.assertEquals((Object)value, (Object)new CustomElement(this.elementDefinition, this.baseElement).get());
    }

    @Test
    public void testSetNonDefaultValue() {
        Object newValue = new Object();
        CustomElement customElement = new CustomElement(this.elementDefinition, this.baseElement);
        customElement.set(newValue);
        Assert.assertEquals((Object)newValue, (Object)this.elementDefinition.getValue(this.baseElement));
    }

    @Test
    public void testSetDefaultValue() {
        Object currentValue = this.elementDefinition.getValue(this.baseElement);
        CustomElement customElement = new CustomElement(this.elementDefinition, this.baseElement);
        customElement.set(this.defaultValue);
        Assert.assertNotEquals((Object)this.defaultValue, (Object)customElement.get());
        Assert.assertEquals((Object)currentValue, (Object)customElement.get());
    }

    private class ElementDefinitionStub
    extends ElementDefinition<Object> {
        private Object value;

        public ElementDefinitionStub(String name, Object defaultValue) {
            super(name, defaultValue);
        }

        public Object getValue(BaseElement element) {
            return this.value;
        }

        public void setValue(BaseElement element, Object value) {
            this.value = value;
        }
    }
}

